/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.BaseRow;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import javax.sql.RowSetMetaData;

public class InsertRow
extends BaseRow
implements Serializable,
Cloneable {
    private BitSet colsInserted;
    private int cols;
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = 1066099658102869344L;

    public InsertRow(int n) {
        this.origVals = new Object[n];
        this.colsInserted = new BitSet(n);
        this.cols = n;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void markColInserted(int n) {
        this.colsInserted.set(n);
    }

    public boolean isCompleteRow(RowSetMetaData rowSetMetaData) throws SQLException {
        for (int i = 0; i < this.cols; ++i) {
            if (this.colsInserted.get(i) || rowSetMetaData.isNullable(i + 1) != 0) continue;
            return false;
        }
        return true;
    }

    public void initInsertRow() {
        for (int i = 0; i < this.cols; ++i) {
            this.colsInserted.clear(i);
        }
    }

    @Override
    public Object getColumnObject(int n) throws SQLException {
        if (!this.colsInserted.get(n - 1)) {
            throw new SQLException(this.resBundle.handleGetObject("insertrow.novalue").toString());
        }
        return this.origVals[n - 1];
    }

    @Override
    public void setColumnObject(int n, Object object) {
        this.origVals[n - 1] = object;
        this.markColInserted(n - 1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

