/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ArithmeticInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ClassGen;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.FieldInstruction;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.GETSTATIC;
import com.sun.org.apache.bcel.internal.generic.GOTO;
import com.sun.org.apache.bcel.internal.generic.GOTO_W;
import com.sun.org.apache.bcel.internal.generic.IFEQ;
import com.sun.org.apache.bcel.internal.generic.IFGE;
import com.sun.org.apache.bcel.internal.generic.IFGT;
import com.sun.org.apache.bcel.internal.generic.IFLE;
import com.sun.org.apache.bcel.internal.generic.IFLT;
import com.sun.org.apache.bcel.internal.generic.IFNE;
import com.sun.org.apache.bcel.internal.generic.IFNONNULL;
import com.sun.org.apache.bcel.internal.generic.IFNULL;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPNE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPNE;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.INVOKEDYNAMIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InvokeInstruction;
import com.sun.org.apache.bcel.internal.generic.JSR;
import com.sun.org.apache.bcel.internal.generic.JSR_W;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.bcel.internal.generic.PUTFIELD;
import com.sun.org.apache.bcel.internal.generic.PUTSTATIC;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.StackInstruction;
import com.sun.org.apache.bcel.internal.generic.Type;

public class InstructionFactory {
    private static final String[] short_names = new String[]{"C", "F", "D", "B", "S", "I", "L"};
    private ClassGen cg;
    private ConstantPoolGen cp;
    private static final MethodObject[] append_mos = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG})};

    public InstructionFactory(ClassGen cg, ConstantPoolGen cp) {
        this.cg = cg;
        this.cp = cp;
    }

    public InstructionFactory(ClassGen cg) {
        this(cg, cg.getConstantPool());
    }

    public InstructionFactory(ConstantPoolGen cp) {
        this(null, cp);
    }

    public InvokeInstruction createInvoke(String class_name, String name, Type ret_type, Type[] arg_types, short kind) {
        return this.createInvoke(class_name, name, ret_type, arg_types, kind, kind == 185);
    }

    public InvokeInstruction createInvoke(String class_name, String name, Type ret_type, Type[] arg_types, short kind, boolean use_interface) {
        if (kind != 183 && kind != 182 && kind != 184 && kind != 185 && kind != 186) {
            throw new IllegalArgumentException("Unknown invoke kind: " + kind);
        }
        int nargs = 0;
        String signature = Type.getMethodSignature(ret_type, arg_types);
        for (Type arg_type : arg_types) {
            nargs += arg_type.getSize();
        }
        int index = use_interface ? this.cp.addInterfaceMethodref(class_name, name, signature) : this.cp.addMethodref(class_name, name, signature);
        switch (kind) {
            case 183: {
                return new INVOKESPECIAL(index);
            }
            case 182: {
                return new INVOKEVIRTUAL(index);
            }
            case 184: {
                return new INVOKESTATIC(index);
            }
            case 185: {
                return new INVOKEINTERFACE(index, nargs + 1);
            }
            case 186: {
                return new INVOKEDYNAMIC(index);
            }
        }
        throw new IllegalStateException("Unknown invoke kind: " + kind);
    }

    public InstructionList createPrintln(String s) {
        InstructionList il = new InstructionList();
        int out = this.cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int println = this.cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
        il.append(new GETSTATIC(out));
        il.append(new PUSH(this.cp, s));
        il.append(new INVOKEVIRTUAL(println));
        return il;
    }

    public Instruction createConstant(Object value) {
        PUSH push;
        if (value instanceof Number) {
            push = new PUSH(this.cp, (Number)value);
        } else if (value instanceof String) {
            push = new PUSH(this.cp, (String)value);
        } else if (value instanceof Boolean) {
            push = new PUSH(this.cp, (Boolean)value);
        } else if (value instanceof Character) {
            push = new PUSH(this.cp, (Character)value);
        } else {
            throw new ClassGenException("Illegal type: " + value.getClass());
        }
        return push.getInstruction();
    }

    private InvokeInstruction createInvoke(MethodObject m, short kind) {
        return this.createInvoke(m.class_name, m.name, m.result_type, m.arg_types, kind);
    }

    private static boolean isString(Type type) {
        return type instanceof ObjectType && ((ObjectType)type).getClassName().equals("java.lang.String");
    }

    public Instruction createAppend(Type type) {
        byte t = type.getType();
        if (InstructionFactory.isString(type)) {
            return this.createInvoke(append_mos[0], (short)182);
        }
        switch (t) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(append_mos[t], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(append_mos[1], (short)182);
            }
        }
        throw new IllegalArgumentException("No append for this type? " + type);
    }

    public FieldInstruction createFieldAccess(String class_name, String name, Type type, short kind) {
        String signature = type.getSignature();
        int index = this.cp.addFieldref(class_name, name, signature);
        switch (kind) {
            case 180: {
                return new GETFIELD(index);
            }
            case 181: {
                return new PUTFIELD(index);
            }
            case 178: {
                return new GETSTATIC(index);
            }
            case 179: {
                return new PUTSTATIC(index);
            }
        }
        throw new IllegalArgumentException("Unknown getfield kind:" + kind);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }

    public static ReturnInstruction createReturn(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConst.ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConst.IRETURN;
            }
            case 6: {
                return InstructionConst.FRETURN;
            }
            case 7: {
                return InstructionConst.DRETURN;
            }
            case 11: {
                return InstructionConst.LRETURN;
            }
            case 12: {
                return InstructionConst.RETURN;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    private static ArithmeticInstruction createBinaryIntOp(char first, String op) {
        switch (first) {
            case '-': {
                return InstructionConst.ISUB;
            }
            case '+': {
                return InstructionConst.IADD;
            }
            case '%': {
                return InstructionConst.IREM;
            }
            case '*': {
                return InstructionConst.IMUL;
            }
            case '/': {
                return InstructionConst.IDIV;
            }
            case '&': {
                return InstructionConst.IAND;
            }
            case '|': {
                return InstructionConst.IOR;
            }
            case '^': {
                return InstructionConst.IXOR;
            }
            case '<': {
                return InstructionConst.ISHL;
            }
            case '>': {
                return op.equals(">>>") ? InstructionConst.IUSHR : InstructionConst.ISHR;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + op);
    }

    private static ArithmeticInstruction createBinaryLongOp(char first, String op) {
        switch (first) {
            case '-': {
                return InstructionConst.LSUB;
            }
            case '+': {
                return InstructionConst.LADD;
            }
            case '%': {
                return InstructionConst.LREM;
            }
            case '*': {
                return InstructionConst.LMUL;
            }
            case '/': {
                return InstructionConst.LDIV;
            }
            case '&': {
                return InstructionConst.LAND;
            }
            case '|': {
                return InstructionConst.LOR;
            }
            case '^': {
                return InstructionConst.LXOR;
            }
            case '<': {
                return InstructionConst.LSHL;
            }
            case '>': {
                return op.equals(">>>") ? InstructionConst.LUSHR : InstructionConst.LSHR;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + op);
    }

    private static ArithmeticInstruction createBinaryFloatOp(char op) {
        switch (op) {
            case '-': {
                return InstructionConst.FSUB;
            }
            case '+': {
                return InstructionConst.FADD;
            }
            case '*': {
                return InstructionConst.FMUL;
            }
            case '/': {
                return InstructionConst.FDIV;
            }
            case '%': {
                return InstructionConst.FREM;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + op);
    }

    private static ArithmeticInstruction createBinaryDoubleOp(char op) {
        switch (op) {
            case '-': {
                return InstructionConst.DSUB;
            }
            case '+': {
                return InstructionConst.DADD;
            }
            case '*': {
                return InstructionConst.DMUL;
            }
            case '/': {
                return InstructionConst.DDIV;
            }
            case '%': {
                return InstructionConst.DREM;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + op);
    }

    public static ArithmeticInstruction createBinaryOperation(String op, Type type) {
        char first = op.charAt(0);
        switch (type.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(first, op);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(first, op);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(first);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(first);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static StackInstruction createPop(int size) {
        return size == 2 ? InstructionConst.POP2 : InstructionConst.POP;
    }

    public static StackInstruction createDup(int size) {
        return size == 2 ? InstructionConst.DUP2 : InstructionConst.DUP;
    }

    public static StackInstruction createDup_2(int size) {
        return size == 2 ? InstructionConst.DUP2_X2 : InstructionConst.DUP_X2;
    }

    public static StackInstruction createDup_1(int size) {
        return size == 2 ? InstructionConst.DUP2_X1 : InstructionConst.DUP_X1;
    }

    public static LocalVariableInstruction createStore(Type type, int index) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(index);
            }
            case 6: {
                return new FSTORE(index);
            }
            case 7: {
                return new DSTORE(index);
            }
            case 11: {
                return new LSTORE(index);
            }
            case 13: 
            case 14: {
                return new ASTORE(index);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static LocalVariableInstruction createLoad(Type type, int index) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(index);
            }
            case 6: {
                return new FLOAD(index);
            }
            case 7: {
                return new DLOAD(index);
            }
            case 11: {
                return new LLOAD(index);
            }
            case 13: 
            case 14: {
                return new ALOAD(index);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayLoad(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConst.BALOAD;
            }
            case 5: {
                return InstructionConst.CALOAD;
            }
            case 9: {
                return InstructionConst.SALOAD;
            }
            case 10: {
                return InstructionConst.IALOAD;
            }
            case 6: {
                return InstructionConst.FALOAD;
            }
            case 7: {
                return InstructionConst.DALOAD;
            }
            case 11: {
                return InstructionConst.LALOAD;
            }
            case 13: 
            case 14: {
                return InstructionConst.AALOAD;
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayStore(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConst.BASTORE;
            }
            case 5: {
                return InstructionConst.CASTORE;
            }
            case 9: {
                return InstructionConst.SASTORE;
            }
            case 10: {
                return InstructionConst.IASTORE;
            }
            case 6: {
                return InstructionConst.FASTORE;
            }
            case 7: {
                return InstructionConst.DASTORE;
            }
            case 11: {
                return InstructionConst.LASTORE;
            }
            case 13: 
            case 14: {
                return InstructionConst.AASTORE;
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public Instruction createCast(Type src_type, Type dest_type) {
        if (src_type instanceof BasicType && dest_type instanceof BasicType) {
            byte dest = dest_type.getType();
            int src = src_type.getType();
            if (dest == 11 && (src == 5 || src == 8 || src == 9)) {
                src = 10;
            }
            String name = "com.sun.org.apache.bcel.internal.generic." + short_names[src - 5] + "2" + short_names[dest - 5];
            Instruction i = null;
            try {
                i = (Instruction)Class.forName(name).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not find instruction: " + name, e);
            }
            return i;
        }
        if (src_type instanceof ReferenceType && dest_type instanceof ReferenceType) {
            if (dest_type instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)dest_type));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)dest_type).getClassName()));
        }
        throw new IllegalArgumentException("Cannot cast " + src_type + " to " + dest_type);
    }

    public GETFIELD createGetField(String class_name, String name, Type t) {
        return new GETFIELD(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public GETSTATIC createGetStatic(String class_name, String name, Type t) {
        return new GETSTATIC(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public PUTFIELD createPutField(String class_name, String name, Type t) {
        return new PUTFIELD(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public PUTSTATIC createPutStatic(String class_name, String name, Type t) {
        return new PUTSTATIC(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public CHECKCAST createCheckCast(ReferenceType t) {
        if (t instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)t));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)t));
    }

    public INSTANCEOF createInstanceOf(ReferenceType t) {
        if (t instanceof ArrayType) {
            return new INSTANCEOF(this.cp.addArrayClass((ArrayType)t));
        }
        return new INSTANCEOF(this.cp.addClass((ObjectType)t));
    }

    public NEW createNew(ObjectType t) {
        return new NEW(this.cp.addClass(t));
    }

    public NEW createNew(String s) {
        return this.createNew(ObjectType.getInstance(s));
    }

    public Instruction createNewArray(Type t, short dim) {
        if (dim == 1) {
            if (t instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)t));
            }
            if (t instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)t));
            }
            return new NEWARRAY(t.getType());
        }
        ArrayType at = t instanceof ArrayType ? (ArrayType)t : new ArrayType(t, (int)dim);
        return new MULTIANEWARRAY(this.cp.addArrayClass(at), dim);
    }

    public static Instruction createNull(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConst.ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConst.ICONST_0;
            }
            case 6: {
                return InstructionConst.FCONST_0;
            }
            case 7: {
                return InstructionConst.DCONST_0;
            }
            case 11: {
                return InstructionConst.LCONST_0;
            }
            case 12: {
                return InstructionConst.NOP;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static BranchInstruction createBranchInstruction(short opcode, InstructionHandle target) {
        switch (opcode) {
            case 153: {
                return new IFEQ(target);
            }
            case 154: {
                return new IFNE(target);
            }
            case 155: {
                return new IFLT(target);
            }
            case 156: {
                return new IFGE(target);
            }
            case 157: {
                return new IFGT(target);
            }
            case 158: {
                return new IFLE(target);
            }
            case 159: {
                return new IF_ICMPEQ(target);
            }
            case 160: {
                return new IF_ICMPNE(target);
            }
            case 161: {
                return new IF_ICMPLT(target);
            }
            case 162: {
                return new IF_ICMPGE(target);
            }
            case 163: {
                return new IF_ICMPGT(target);
            }
            case 164: {
                return new IF_ICMPLE(target);
            }
            case 165: {
                return new IF_ACMPEQ(target);
            }
            case 166: {
                return new IF_ACMPNE(target);
            }
            case 167: {
                return new GOTO(target);
            }
            case 168: {
                return new JSR(target);
            }
            case 198: {
                return new IFNULL(target);
            }
            case 199: {
                return new IFNONNULL(target);
            }
            case 200: {
                return new GOTO_W(target);
            }
            case 201: {
                return new JSR_W(target);
            }
        }
        throw new IllegalArgumentException("Invalid opcode: " + opcode);
    }

    public void setClassGen(ClassGen c) {
        this.cg = c;
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(ConstantPoolGen c) {
        this.cp = c;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    private static class MethodObject {
        final Type[] arg_types;
        final Type result_type;
        final String class_name;
        final String name;

        MethodObject(String c, String n, Type r, Type[] a) {
            this.class_name = c;
            this.name = n;
            this.result_type = r;
            this.arg_types = a;
        }
    }
}

