/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.lwawt.macosx.CFRetainedResource;

class CAccessible
extends CFRetainedResource
implements Accessible {
    private static Field nativeAXResourceField = CAccessible.getNativeAXResourceField();
    private Accessible accessible;
    private AccessibleContext activeDescendant;

    static Field getNativeAXResourceField() {
        try {
            Field field = AccessibleContext.class.getDeclaredField("nativeAXResource");
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CAccessible getCAccessible(Accessible accessible) {
        if (accessible == null) {
            return null;
        }
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        try {
            CAccessible cAccessible = (CAccessible)nativeAXResourceField.get(accessibleContext);
            if (cAccessible != null) {
                return cAccessible;
            }
            CAccessible cAccessible2 = new CAccessible(accessible);
            nativeAXResourceField.set(accessibleContext, cAccessible2);
            return cAccessible2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static native void unregisterFromCocoaAXSystem(long var0);

    private static native void valueChanged(long var0);

    private static native void selectedTextChanged(long var0);

    private static native void selectionChanged(long var0);

    private static native void menuOpened(long var0);

    private static native void menuClosed(long var0);

    private static native void menuItemSelected(long var0);

    private CAccessible(Accessible accessible) {
        super(0L, true);
        if (accessible == null) {
            throw new NullPointerException();
        }
        this.accessible = accessible;
        if (accessible instanceof Component) {
            this.addNotificationListeners((Component)((Object)accessible));
        }
    }

    @Override
    protected synchronized void dispose() {
        if (this.ptr != 0L) {
            CAccessible.unregisterFromCocoaAXSystem(this.ptr);
        }
        super.dispose();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessible.getAccessibleContext();
    }

    public void addNotificationListeners(Component component) {
        Object object;
        if (component instanceof Accessible) {
            object = ((Accessible)((Object)component)).getAccessibleContext();
            ((AccessibleContext)object).addPropertyChangeListener(new AXChangeNotifier());
        }
        if (component instanceof JProgressBar) {
            object = (JProgressBar)component;
            ((JProgressBar)object).addChangeListener(new AXProgressChangeNotifier());
        } else if (component instanceof JSlider) {
            object = (JSlider)component;
            ((JSlider)object).addChangeListener(new AXProgressChangeNotifier());
        }
    }

    static Accessible getSwingAccessible(Accessible accessible) {
        return accessible instanceof CAccessible ? ((CAccessible)accessible).accessible : accessible;
    }

    static AccessibleContext getActiveDescendant(Accessible accessible) {
        return accessible instanceof CAccessible ? ((CAccessible)accessible).activeDescendant : null;
    }

    private class AXProgressChangeNotifier
    implements ChangeListener {
        private AXProgressChangeNotifier() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (CAccessible.this.ptr != 0L) {
                CAccessible.valueChanged(CAccessible.this.ptr);
            }
        }
    }

    private class AXChangeNotifier
    implements PropertyChangeListener {
        private AXChangeNotifier() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (CAccessible.this.ptr != 0L) {
                Object object = propertyChangeEvent.getNewValue();
                Object object2 = propertyChangeEvent.getOldValue();
                if (string.compareTo("AccessibleCaret") == 0) {
                    CAccessible.selectedTextChanged(CAccessible.this.ptr);
                } else if (string.compareTo("AccessibleText") == 0) {
                    CAccessible.valueChanged(CAccessible.this.ptr);
                } else if (string.compareTo("AccessibleSelection") == 0) {
                    CAccessible.selectionChanged(CAccessible.this.ptr);
                } else if (string.compareTo("accessibleTableModelChanged") == 0) {
                    CAccessible.valueChanged(CAccessible.this.ptr);
                } else if (string.compareTo("AccessibleActiveDescendant") == 0) {
                    if (object instanceof AccessibleContext) {
                        CAccessible.this.activeDescendant = (AccessibleContext)object;
                    }
                } else if (string.compareTo("AccessibleState") == 0) {
                    AccessibleContext accessibleContext = CAccessible.this.accessible.getAccessibleContext();
                    AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                    Accessible accessible = accessibleContext.getAccessibleParent();
                    AccessibleRole accessibleRole2 = null;
                    if (accessible != null) {
                        accessibleRole2 = accessible.getAccessibleContext().getAccessibleRole();
                    }
                    if (accessibleRole2 != AccessibleRole.COMBO_BOX) {
                        if (accessibleRole == AccessibleRole.POPUP_MENU) {
                            if (object != null && (AccessibleState)object == AccessibleState.VISIBLE) {
                                CAccessible.menuOpened(CAccessible.this.ptr);
                            } else if (object2 != null && (AccessibleState)object2 == AccessibleState.VISIBLE) {
                                CAccessible.menuClosed(CAccessible.this.ptr);
                            }
                        } else if (accessibleRole == AccessibleRole.MENU_ITEM && object != null && (AccessibleState)object == AccessibleState.FOCUSED) {
                            CAccessible.menuItemSelected(CAccessible.this.ptr);
                        }
                    }
                }
            }
        }
    }
}

