/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleMainClass
extends Attribute {
    private int mainClassIndex;

    public ModuleMainClass(ModuleMainClass c) {
        this(c.getNameIndex(), c.getLength(), c.getHostClassIndex(), c.getConstantPool());
    }

    public ModuleMainClass(int name_index, int length, int mainClassIndex, ConstantPool constantPool) {
        super((byte)26, name_index, length, constantPool);
        this.mainClassIndex = mainClassIndex;
    }

    ModuleMainClass(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        this(nameIndex, length, 0, constantPool);
        this.mainClassIndex = input.readUnsignedShort();
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleMainClass(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.mainClassIndex);
    }

    public int getHostClassIndex() {
        return this.mainClassIndex;
    }

    public void setHostClassIndex(int mainClassIndex) {
        this.mainClassIndex = mainClassIndex;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModuleMainClass: ");
        String class_name = super.getConstantPool().getConstantString(this.mainClassIndex, (byte)7);
        buf.append(Utility.compactClassName(class_name, false));
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ModuleMainClass c = (ModuleMainClass)this.clone();
        c.setConstantPool(_constant_pool);
        return c;
    }
}

