/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.mc.convenience.Ha3Signal;
import eu.ha3.mc.haddon.Haddon;
import eu.ha3.mc.haddon.PrivateAccessException;
import paulscode.sound.SoundSystem;

public class Ha3SoundCommunicator {
    private Haddon mod;
    private bev sndManager;
    private SoundSystem sndSystem;
    private Ha3SoundThread soundThread;
    private String prefix;
    private int maxIDs;
    private int lastSoundID;

    Ha3SoundCommunicator(Haddon haddon, String prefix) {
        this.mod = haddon;
        this.prefix = prefix;
        this.maxIDs = 256;
    }

    public void setMaxIDs(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxIDs = max;
    }

    public boolean isUseable() {
        return this.sndSystem != null && this.sndManager != null;
    }

    public void load(Ha3Signal onSuccess, Ha3Signal onFailure) {
        if (!this.isUseable()) {
            this.soundThread = new Ha3SoundThread(this, onSuccess, onFailure);
            this.soundThread.start();
        }
    }

    public boolean loadSoundManager() {
        if (this.sndManager == null) {
            this.sndManager = this.mod.getManager().getMinecraft().A;
        }
        return this.sndManager != null;
    }

    public SoundSystem getSoundSystem() {
        SoundSystem soundSystemBeforeLoading = this.sndSystem;
        try {
            this.loadSoundSystem();
        }
        catch (PrivateAccessException e2) {
            e2.printStackTrace();
        }
        if (soundSystemBeforeLoading != this.sndSystem) {
            System.err.println("(Ha3SoundCommunicator) WARNING: SoundSystem was altered during runtime.");
            System.err.println("(Ha3SoundCommunicator) Behavior cannot be predicted at this point.");
        }
        return this.sndSystem;
    }

    public bev getSoundManager() {
        return this.sndManager;
    }

    public boolean loadSoundSystem() throws PrivateAccessException {
        if (this.sndSystem == null) {
            this.sndSystem = (SoundSystem)this.mod.getManager().getUtility().getPrivateValueLiteral(bev.class, this.mod.getManager().getMinecraft().A, "a", 0);
        }
        return this.sndSystem != null;
    }

    public void playSoundViaManager(String sound, float x2, float y2, float z2, float vol, float pitch) {
        if (!this.isUseable()) {
            return;
        }
        this.sndManager.a(sound, x2, y2, z2, vol, pitch);
    }

    public void playSound(String sound, float x2, float y2, float z2, float vol, float pitch) {
        if (!this.isUseable()) {
            return;
        }
        try {
            float soundVolume = this.mod.getManager().getMinecraft().y.b;
            if (soundVolume == 0.0f) {
                return;
            }
            beu soundpoolentry = ((bex)this.mod.getManager().getUtility().getPrivateValueLiteral(bev.class, this.sndManager, "b", 1)).a(sound);
            if (soundpoolentry != null && vol > 0.0f) {
                this.lastSoundID = (this.lastSoundID + 1) % this.maxIDs;
                String sourceName = this.prefix + this.lastSoundID;
                float rollf = 16.0f;
                if (vol > 1.0f) {
                    rollf *= vol;
                }
                this.sndSystem.newSource(vol > 1.0f, sourceName, soundpoolentry.b, soundpoolentry.a, false, x2, y2, z2, 2, rollf);
                this.sndSystem.setPitch(sourceName, pitch);
                if (vol > 1.0f) {
                    vol = 1.0f;
                }
                this.sndSystem.setVolume(sourceName, vol * soundVolume);
                this.sndSystem.play(sourceName);
            }
        }
        catch (PrivateAccessException e2) {
            // empty catch block
        }
    }

    public void playSound(String sound, float x2, float y2, float z2, float vol, float pitch, int attnm, float rollf) {
        if (!this.isUseable()) {
            return;
        }
        try {
            float soundVolume = this.mod.getManager().getMinecraft().y.b;
            if (soundVolume == 0.0f) {
                return;
            }
            beu soundpoolentry = ((bex)this.mod.getManager().getUtility().getPrivateValueLiteral(bev.class, this.sndManager, "b", 1)).a(sound);
            if (soundpoolentry != null && vol > 0.0f) {
                this.lastSoundID = (this.lastSoundID + 1) % this.maxIDs;
                String sourceName = this.prefix + this.lastSoundID;
                this.sndSystem.newSource(vol > 1.0f, sourceName, soundpoolentry.b, soundpoolentry.a, false, x2, y2, z2, attnm, rollf);
                this.sndSystem.setPitch(sourceName, pitch);
                if (vol > 1.0f) {
                    vol = 1.0f;
                }
                this.sndSystem.setVolume(sourceName, vol * soundVolume);
                this.sndSystem.play(sourceName);
            }
        }
        catch (PrivateAccessException e2) {
            // empty catch block
        }
    }
}

