/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.mc.haddon.PrivateAccessException;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class HaddonUtilitySingleton {
    public static final Logger LOGGER = Logger.getLogger("HaddonUtilitySingleton");
    private static final HaddonUtilitySingleton instance = new HaddonUtilitySingleton();
    private Field fieldMod;

    private HaddonUtilitySingleton() {
        try {
            this.fieldMod = Field.class.getDeclaredField("modifiers");
            this.fieldMod.setAccessible(true);
        }
        catch (SecurityException e2) {
            throw new RuntimeException("haddonUtility critical failure: Security");
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException("haddonUtility critical failure: NoSuchField");
        }
    }

    public static HaddonUtilitySingleton getInstance() {
        return instance;
    }

    public Field getFieldModifiers() {
        return this.fieldMod;
    }

    public Object getPrivateValue(Class classToPerformOn, Object instanceToPerformOn, int zeroOffsets) throws PrivateAccessException {
        try {
            Field field = classToPerformOn.getDeclaredFields()[zeroOffsets];
            field.setAccessible(true);
            return field.get(instanceToPerformOn);
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new RuntimeException("getPrivateValue critical failure: IllegalAccess");
        }
        catch (IllegalArgumentException e2) {
            throw new PrivateAccessException("getPrivateValue has failed: IllegalArgument");
        }
        catch (SecurityException e3) {
            throw new PrivateAccessException("getPrivateValue has failed: Security");
        }
    }

    public void setPrivateValue(Class classToPerformOn, Object instanceToPerformOn, int zeroOffsets, Object newValue) throws PrivateAccessException {
        try {
            Field field = classToPerformOn.getDeclaredFields()[zeroOffsets];
            field.setAccessible(true);
            int j2 = this.fieldMod.getInt(field);
            if ((j2 & 0x10) != 0) {
                this.fieldMod.setInt(field, j2 & 0xFFFFFFEF);
            }
            field.set(instanceToPerformOn, newValue);
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new RuntimeException("getPrivateValue critical failure: IllegalAccess");
        }
        catch (IllegalArgumentException e2) {
            throw new PrivateAccessException("setPrivateValue has failed: IllegalArgument");
        }
        catch (SecurityException e3) {
            throw new PrivateAccessException("setPrivateValue has failed: Security");
        }
    }

    public Object getPrivateValueViaName(Class classToPerformOn, Object instanceToPerformOn, String obf) throws PrivateAccessException {
        try {
            Field field = classToPerformOn.getDeclaredField(obf);
            field.setAccessible(true);
            return field.get(instanceToPerformOn);
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new RuntimeException("getPrivateValue critical failure: IllegalAccess");
        }
        catch (IllegalArgumentException e2) {
            LOGGER.fine("getPrivateValue has failed: IllegalArgument on field " + obf);
            throw new PrivateAccessException("getPrivateValue has failed: IllegalArgument");
        }
        catch (SecurityException e3) {
            LOGGER.fine("getPrivateValue has failed: Security on field " + obf);
            throw new PrivateAccessException("getPrivateValue has failed: Security");
        }
        catch (NoSuchFieldException e4) {
            LOGGER.fine("getPrivateValue has failed: NoSuchField on field " + obf);
            throw new PrivateAccessException("getPrivateValue has failed: NoSuchField");
        }
    }

    public void setPrivateValueViaName(Class classToPerformOn, Object instanceToPerformOn, String obf, Object newValue) throws PrivateAccessException {
        try {
            Field field = classToPerformOn.getDeclaredField(obf);
            field.setAccessible(true);
            int j2 = this.fieldMod.getInt(field);
            if ((j2 & 0x10) != 0) {
                this.fieldMod.setInt(field, j2 & 0xFFFFFFEF);
            }
            field.set(instanceToPerformOn, newValue);
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new RuntimeException("getPrivateValue critical failure: IllegalAccess");
        }
        catch (IllegalArgumentException e2) {
            LOGGER.fine("setPrivateValue has failed: IllegalArgument on field " + obf);
            throw new PrivateAccessException("setPrivateValue has failed: IllegalArgument");
        }
        catch (SecurityException e3) {
            LOGGER.fine("setPrivateValue has failed: Security on field " + obf);
            throw new PrivateAccessException("setPrivateValue has failed: Security");
        }
        catch (NoSuchFieldException e4) {
            LOGGER.fine("setPrivateValue has failed: NoSuchField on field " + obf);
            throw new PrivateAccessException("setPrivateValue has failed: NoSuchField");
        }
    }
}

