/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.engine.MAtmosLogger;
import eu.ha3.mc.convenience.Ha3Signal;
import eu.ha3.mc.convenience.Ha3StaticUtilities;
import eu.ha3.mc.haddon.SupportsEverythingReady;
import eu.ha3.mc.haddon.SupportsFrameEvents;
import eu.ha3.mc.haddon.SupportsKeyEvents;
import eu.ha3.mc.haddon.SupportsTickEvents;
import eu.ha3.util.property.simple.ConfigProperty;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;

public class MAtMod
extends HaddonImpl
implements SupportsFrameEvents,
SupportsTickEvents,
SupportsKeyEvents,
SupportsEverythingReady {
    public static final MAtLogger LOGGER = new MAtLogger();
    public static final int VERSION = 21;
    private static final boolean KNOWLEDGE_IS_SLOW = false;
    private MAtModPhase phase = MAtModPhase.NOT_INITIALIZED;
    private ConfigProperty config;
    private Ha3SoundCommunicator sndComm;
    private MAtUserControl userControl;
    private MAtDataGatherer dataGatherer;
    private MAtExpansionManager expansionManager;
    private MAtSoundManagerMaster soundManagerMaster;
    private MAtUpdateNotifier updateNotifier;
    private boolean isFatalError;
    private boolean isRunning;
    private boolean firstTickPassed;
    private TimeStatistic timeStatistic;
    private boolean hasSentSignalToTurnOn;
    private boolean everythingIsReady;

    public MAtMod() {
        this.setModLogger(Level.INFO);
        this.setEngineLogger(Level.OFF);
    }

    public void setModLogger(Level lvl) {
    }

    public void setEngineLogger(Level lvl) {
        MAtmosLogger.LOGGER.setLevel(lvl);
    }

    @Override
    public void onLoad() {
        if (!new File(Minecraft.b(), "matmos/").exists()) {
            this.isFatalError = true;
            this.manager().hookTickEvents(true);
            return;
        }
        this.timeStatistic = new TimeStatistic(Locale.ENGLISH);
        this.sndComm = new Ha3SoundCommunicator(this, "MAtmos_");
        this.userControl = new MAtUserControl(this);
        this.dataGatherer = new MAtDataGatherer(this);
        this.expansionManager = new MAtExpansionManager(this);
        this.updateNotifier = new MAtUpdateNotifier(this);
        this.soundManagerMaster = new MAtSoundManagerMaster(this);
        this.manager().hookFrameEvents(true);
        this.manager().hookTickEvents(true);
        this.config = new ConfigProperty();
        this.config.setProperty("dump.enabled", true);
        this.config.setProperty("start.enabled", true);
        this.config.setProperty("reversed.controls", false);
        this.config.setProperty("sound.autopreview", true);
        this.config.setProperty("globalvolume.scale", Float.valueOf(1.0f));
        this.config.setProperty("update_found.enabled", true);
        this.config.setProperty("update_found.version", 21);
        this.config.setProperty("update_found.display.remaining.value", 0);
        this.config.setProperty("update_found.display.count.value", 3);
        this.config.commit();
        try {
            this.config.setSource(new File(Minecraft.b(), "matmos/userconfig.cfg").getCanonicalPath());
            this.config.load();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Error caused config not to work: " + e2.getMessage());
        }
        this.soundManagerMaster.setVolume(this.config.getFloat("globalvolume.scale"));
        this.updateNotifier.loadConfig(this.config);
        LOGGER.info("Took " + this.timeStatistic.getSecondsAsString(1) + " seconds to setup MAtmos base.");
        LOGGER.info("Pre-loading.");
        this.userControl.load();
        this.phase = MAtModPhase.NOT_YET_ENABLED;
        if (this.config.getBoolean("start.enabled")) {
            this.initializeAndEnable();
        }
    }

    public void initializeAndEnable() {
        if (this.phase != MAtModPhase.NOT_YET_ENABLED) {
            return;
        }
        this.timeStatistic = new TimeStatistic(Locale.ENGLISH);
        this.phase = MAtModPhase.CONSTRUCTING;
        LOGGER.info("Constructing.");
        this.dataGatherer.load();
        this.sndComm.load(new Ha3Signal(){

            @Override
            public void signal() {
                MAtMod.this.loadResourcesPhase();
            }
        }, new Ha3Signal(){

            @Override
            public void signal() {
                MAtMod.this.sndCommFailed();
            }
        });
        this.expansionManager.loadExpansions();
        LOGGER.info("Took " + this.timeStatistic.getSecondsAsString(1) + " seconds to enable MAtmos.");
    }

    private void sndCommFailed() {
        this.phase = MAtModPhase.SOUNDCOMMUNICATOR_FAILURE;
        LOGGER.severe("CRITICAL Error with SoundCommunicator (after " + this.timeStatistic.getSecondsAsString(3) + " s.). Will not load.");
        this.isFatalError = true;
        this.phase = MAtModPhase.SOUNDCOMMUNICATOR_FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFirstBlocker() {
        File folder = new File(Minecraft.b(), "matmos/reloader_blacklist/");
        if (!folder.exists()) {
            return null;
        }
        File[] arr$ = folder.listFiles();
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            File file = arr$[i$];
            if (file.getName().endsWith(".list")) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String[] contents = line.split("\t");
                            if (contents.length <= 0 || contents[0].length() <= 0 || !Ha3StaticUtilities.classExists(contents[0], this)) continue;
                            if (contents.length > 1) {
                                String string = contents[1];
                                return string;
                            }
                            String string = "A blocker was detected.";
                            return string;
                        }
                    }
                    catch (IOException e2) {
                    }
                    finally {
                        this.closeAndShutUp(reader);
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            ++i$;
        }
        return null;
    }

    private void closeAndShutUp(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadResourcesPhase() {
        this.phase = MAtModPhase.RESOURCE_LOADER;
        LOGGER.info("SoundCommunicator loaded (after " + this.timeStatistic.getSecondsAsString(3) + " s.).");
        String firstBlocker = this.getFirstBlocker();
        if (firstBlocker != null) {
            LOGGER.warning(firstBlocker);
            LOGGER.warning("MAtmos will not attempt load sounds on its own at all.");
            this.loadFinalPhase();
        } else {
            LOGGER.info("Bypassing Resource Reloader threaded wait. This may cause issues.");
            try {
                new MAtResourceReloader(this, null).reloadResources();
            }
            catch (Exception e2) {
                LOGGER.severe("A severe error has occured while trying to reload resources.");
                LOGGER.severe("MAtmos may not function properly.");
                e2.printStackTrace();
                try {
                    FileWriter writer = new FileWriter(new File(Minecraft.b(), "matmos_error.log"), true);
                    PrintWriter pw2 = new PrintWriter(writer);
                    e2.printStackTrace(pw2);
                    pw2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.loadFinalPhase();
        }
    }

    private void loadFinalPhase() {
        this.phase = MAtModPhase.FINAL_PHASE;
        LOGGER.info("ResourceReloader finished (after " + this.timeStatistic.getSecondsAsString(3) + " s.).");
        this.phase = MAtModPhase.READY;
        LOGGER.info("Ready.");
        this.startRunning();
        if (this.everythingIsReady) {
            this.trySendSignalToTurnOn();
        }
    }

    @Override
    public void onEverythingReady() {
        if (!this.trySendSignalToTurnOn()) {
            LOGGER.info("MAtmos is not yet enabled and mods are loaded: Knowledge will be built later...");
        }
        this.everythingIsReady = true;
    }

    private boolean trySendSignalToTurnOn() {
        if (this.phase != MAtModPhase.READY) {
            return false;
        }
        if (!this.hasSentSignalToTurnOn) {
            this.hasSentSignalToTurnOn = true;
            LOGGER.info("Now building knowledge...");
            this.expansionManager.signalReadyToTurnOn();
        }
        return true;
    }

    public void reloadAndStart() {
        if (!this.isReady()) {
            return;
        }
        if (this.isRunning) {
            return;
        }
        this.expansionManager.clearExpansions();
        TimeStatistic stat = new TimeStatistic(Locale.ENGLISH);
        this.expansionManager.loadExpansions();
        LOGGER.info("Expansions loaded (" + stat.getSecondsAsString(1) + "s).");
        this.startRunning();
    }

    public void startRunning() {
        if (!this.isReady()) {
            return;
        }
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        LOGGER.fine("Loading...");
        this.expansionManager.modWasTurnedOnOrOff();
        LOGGER.fine("Loaded.");
    }

    public void stopRunning() {
        if (!this.isReady()) {
            return;
        }
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        LOGGER.fine("Stopping...");
        this.expansionManager.modWasTurnedOnOrOff();
        LOGGER.fine("Stopped.");
        this.createDataDump();
    }

    private void createDataDump() {
        if (!this.config.getBoolean("dump.enabled")) {
            return;
        }
        LOGGER.fine("Dumping data.");
        try {
            File file = new File(Minecraft.b(), "data_dump.xml");
            file.createNewFile();
            FileWriter fw2 = new FileWriter(file);
            fw2.write(this.getDataGatherer().getData().createXML());
            fw2.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void printChat(Object ... args) {
        Object[] in2 = new Object[]{"\u00a7f", "MAtmos: "};
        Object[] dest = new Object[in2.length + args.length];
        System.arraycopy(in2, 0, dest, 0, in2.length);
        System.arraycopy(args, 0, dest, in2.length, args.length);
        this.util().printChat(dest);
    }

    public void printChatShort(Object ... args) {
        Object[] in2 = new Object[]{"\u00a7f", ""};
        Object[] dest = new Object[in2.length + args.length];
        System.arraycopy(in2, 0, dest, 0, in2.length);
        System.arraycopy(args, 0, dest, in2.length, args.length);
        this.util().printChat(dest);
    }

    public MAtSoundManagerMaster getSoundManagerMaster() {
        return this.soundManagerMaster;
    }

    public MAtDataGatherer getDataGatherer() {
        return this.dataGatherer;
    }

    public MAtExpansionManager getExpansionManager() {
        return this.expansionManager;
    }

    public Ha3SoundCommunicator getSoundCommunicator() {
        return this.sndComm;
    }

    public MAtModPhase getPhase() {
        return this.phase;
    }

    public boolean isFatalError() {
        return this.isFatalError;
    }

    public boolean isReady() {
        return this.phase == MAtModPhase.READY;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void onKey(arv event) {
        this.userControl.communicateKeyBindingEvent(event);
    }

    @Override
    public void onFrame(float semi) {
        if (this.isFatalError) {
            return;
        }
        if (!this.isRunning) {
            return;
        }
        this.expansionManager.soundRoutine();
        this.soundManagerMaster.routine();
        this.userControl.frameRoutine(semi);
    }

    @Override
    public void onTick() {
        if (this.isFatalError) {
            this.printChat("\u00a7e", "A fatal error has occured. MAtmos will not load.");
            if (!new File(Minecraft.b(), "matmos/").exists()) {
                this.printChat("\u00a7f", "Are you sure you installed MAtmos correctly?");
                this.printChat("\u00a7f", "The folder called ", "\u00a7e", ".minecraft/matmos/", "\u00a7e", " was NOT found. This folder should exist on a normal installation.");
            }
            this.manager().hookTickEvents(false);
            this.manager().hookFrameEvents(false);
            return;
        }
        this.userControl.tickRoutine();
        if (this.isRunning) {
            this.dataGatherer.tickRoutine();
            this.expansionManager.dataRoutine();
        }
        if (!this.firstTickPassed) {
            this.firstTickPassed = true;
            this.updateNotifier.attempt();
        }
    }

    public void saveConfig() {
        if (this.config.commit()) {
            LOGGER.info("Saving configuration...");
            this.config.save();
        }
    }

    public ConfigProperty getConfig() {
        return this.config;
    }
}

