/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.mc.convenience.Ha3Signal;

public class MAtScanVolumetricModel {
    private MAtMod mod;
    private MAtScanCoordsOps pipeline;
    private long xstart;
    private long ystart;
    private long zstart;
    private long xsize;
    private long ysize;
    private long zsize;
    private long opspercall;
    private boolean isScanning;
    private long finality;
    private long progress;
    private Ha3Signal onDone;

    MAtScanVolumetricModel(MAtMod mod2) {
        this.mod = mod2;
        this.pipeline = null;
        this.isScanning = false;
    }

    void setPipeline(MAtScanCoordsOps pipelineIn) {
        this.pipeline = pipelineIn;
    }

    void startScan(long x2, long y2, long z2, long xsizeIn, long ysizeIn, long zsizeIn, long opspercallIn, Ha3Signal onDoneIn) {
        if (this.isScanning) {
            return;
        }
        if (this.pipeline == null) {
            return;
        }
        if (opspercallIn <= 0L) {
            throw new IllegalArgumentException();
        }
        int worldHeight = this.mod.util().getWorldHeight();
        if (ysizeIn > (long)worldHeight) {
            ysizeIn = worldHeight;
        }
        this.xsize = xsizeIn;
        this.ysize = ysizeIn;
        this.zsize = zsizeIn;
        if ((y2 -= this.ysize / 2L) < 0L) {
            y2 = 0L;
        } else if (y2 > (long)worldHeight - this.ysize) {
            y2 = (long)worldHeight - this.ysize;
        }
        this.xstart = x2 - this.xsize / 2L;
        this.ystart = y2;
        this.zstart = z2 - this.zsize / 2L;
        this.opspercall = opspercallIn;
        this.progress = 0L;
        this.finality = this.xsize * this.ysize * this.zsize;
        this.pipeline.begin();
        this.isScanning = true;
    }

    void routine() {
        if (!this.isScanning) {
            return;
        }
        long ops = 0L;
        while (ops < this.opspercall && this.progress < this.finality) {
            long x2 = this.xstart + this.progress % this.xsize;
            long z2 = this.zstart + this.progress / this.xsize % this.zsize;
            long y2 = this.ystart + this.progress / this.xsize / this.zsize;
            this.pipeline.input(x2, y2, z2);
            ++ops;
            ++this.progress;
        }
        if (this.progress >= this.finality) {
            this.scanDoneEvent();
        }
    }

    void stopScan() {
        this.isScanning = false;
    }

    private void scanDoneEvent() {
        if (!this.isScanning) {
            return;
        }
        this.pipeline.finish();
        this.stopScan();
        if (this.onDone != null) {
            this.onDone.signal();
        }
    }
}

