/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.matmos.engine.SoundRelay;
import eu.ha3.mc.haddon.PrivateAccessException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import paulscode.sound.SoundSystem;

public class MAtSoundManagerChild
implements SoundRelay,
MAtCustomVolume {
    private MAtMod mod;
    private float managerVolume;
    private Random random;
    private Map tokens;
    private float masterVolumeCheck;
    private float settingsVolumeCheck;

    public MAtSoundManagerChild(MAtMod mod) {
        this.mod = mod;
        this.managerVolume = 1.0f;
        this.random = new Random();
        this.tokens = new HashMap();
        this.masterVolumeCheck = -1.0f;
    }

    private MAtSoundManagerMaster getMaster() {
        return this.mod.getSoundManagerMaster();
    }

    @Override
    public void setVolume(float vol) {
        this.managerVolume = vol;
        this.propagateVolume();
    }

    @Override
    public float getVolume() {
        return this.managerVolume;
    }

    @Override
    public void routine() {
        if (this.masterVolumeCheck != this.getMaster().getVolume() || this.settingsVolumeCheck != this.getMaster().getSettingsVolume()) {
            this.propagateVolume();
            this.masterVolumeCheck = this.getMaster().getVolume();
            this.settingsVolumeCheck = this.getMaster().getSettingsVolume();
        }
    }

    private void propagateVolume() {
        float playbackVolume = this.computePlaybackVolume();
        for (MAtSoundStream stream : this.tokens.values()) {
            stream.setPlaybackVolumeMod(playbackVolume);
        }
    }

    private float computePlaybackVolume() {
        return this.getMaster().getVolume() * this.managerVolume * this.getMaster().getSettingsVolume();
    }

    @Override
    public void cacheSound(String path) {
        this.getMaster().cacheSound(path);
    }

    @Override
    public void playSound(String path, float volume, float pitch, int meta) {
        Minecraft mc2 = this.mod.manager().getMinecraft();
        float nx2 = (float)mc2.g.t;
        float ny2 = (float)mc2.g.u;
        float nz2 = (float)mc2.g.v;
        String equivalent = this.getMaster().getSound(path);
        float soundEffectiveVolume = this.getMaster().getVolume() * this.managerVolume * volume;
        if (soundEffectiveVolume <= 0.0f) {
            return;
        }
        if (meta > 0) {
            double angle = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            ny2 = ny2 + this.random.nextFloat() * (float)meta * 0.2f - (float)meta * 0.01f;
            this.mod.getSoundCommunicator().playSound(equivalent, nx2 += (float)(Math.cos(angle) * (double)meta), ny2, nz2 += (float)(Math.sin(angle) * (double)meta), soundEffectiveVolume, pitch, 0, 0.0f);
        } else {
            this.mod.getSoundCommunicator().playSound(equivalent, nx2, ny2 += 2048.0f, nz2, soundEffectiveVolume, pitch, 0, 0.0f);
        }
    }

    @Override
    public int getNewStreamingToken() {
        int token = this.getMaster().getNewStreamingToken();
        this.tokens.put(token, new MAtSoundStream(token, this));
        return token;
    }

    @Override
    public boolean setupStreamingToken(int token, String path, float volume, float pitch) {
        this.cacheSound(path);
        ((MAtSoundStream)this.tokens.get(token)).setPath(path);
        ((MAtSoundStream)this.tokens.get(token)).setVolume(volume);
        ((MAtSoundStream)this.tokens.get(token)).setPitch(pitch);
        ((MAtSoundStream)this.tokens.get(token)).setPlaybackVolumeMod(this.computePlaybackVolume());
        return true;
    }

    @Override
    public void startStreaming(int token, float fadeDuration, int timesToPlay) {
        ((MAtSoundStream)this.tokens.get(token)).startStreaming(fadeDuration, timesToPlay);
    }

    @Override
    public void stopStreaming(int token, float fadeDuration) {
        ((MAtSoundStream)this.tokens.get(token)).stopStreaming(fadeDuration);
    }

    @Override
    public void pauseStreaming(int token, float fadeDuration) {
        ((MAtSoundStream)this.tokens.get(token)).pauseStreaming();
    }

    @Override
    public void eraseStreamingToken(int token) {
        MAtMod.LOGGER.info("Erasing token #" + token);
        MAtSoundStream stream = (MAtSoundStream)this.tokens.get(token);
        stream.interruptStreaming();
        stream.unallocate();
        this.tokens.remove(token);
    }

    public beu getSoundPoolEntryOf(String path) {
        try {
            return ((bex)this.mod.util().getPrivateValueLiteral(bev.class, this.mod.manager().getMinecraft().A, "b", 1)).a(this.getMaster().getSound(path));
        }
        catch (PrivateAccessException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public SoundSystem getSoundSystem() {
        return this.mod.getSoundCommunicator().getSoundSystem();
    }

    public void finalize() {
        MAtMod.LOGGER.info("Calling finalizer of SMC");
        try {
            for (MAtSoundStream stream : this.tokens.values()) {
                try {
                    stream.unallocate();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }
}

