/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import paulscode.sound.SoundSystem;

public class MAtSoundStream {
    private final String SOURCE_PREFIX = "MATMOS_SRM_";
    private final int number;
    private MAtSoundManagerChild refer;
    private final String sourceName;
    private String path;
    private float volume;
    private float pitch;
    private boolean isInitialized;
    private boolean loopingIsSet;
    private boolean isPaused;
    private URL poolURL;
    private float playbackVolume;

    public MAtSoundStream(int number, MAtSoundManagerChild refer) {
        this.number = number;
        this.refer = refer;
        this.sourceName = this.SOURCE_PREFIX + this.number;
        this.poolURL = null;
    }

    public void startStreaming(float fadeDuration, int timesToPlay) {
        this.ensureInitialized();
        SoundSystem sndSystem = this.refer.getSoundSystem();
        if (!this.loopingIsSet) {
            if (timesToPlay == 0) {
                sndSystem.setLooping(this.sourceName, true);
            } else {
                sndSystem.setLooping(this.sourceName, false);
            }
            this.loopingIsSet = true;
        }
        this.evaluateAndApplyVolume();
        if (fadeDuration == 0.0f) {
            if (this.isPaused) {
                sndSystem.play(this.sourceName);
            } else {
                sndSystem.play(this.sourceName);
                sndSystem.fadeOutIn(this.sourceName, this.poolURL, this.path, 1L, 1L);
            }
        } else {
            sndSystem.play(this.sourceName);
            sndSystem.fadeOutIn(this.sourceName, this.poolURL, this.path, 1L, (long)fadeDuration * 1000L);
        }
    }

    private void ensureInitialized() {
        if (this.isInitialized) {
            return;
        }
        MAtMod.LOGGER.info("Initializing source: " + this.sourceName + " (" + this.path + ")");
        beu poolEntry = this.refer.getSoundPoolEntryOf(this.path);
        if (poolEntry != null) {
            this.poolURL = poolEntry.b;
            MAtMod.LOGGER.info("Source: " + this.sourceName + " is being initialized with URL: " + poolEntry.b.toString());
            SoundSystem sndSystem = this.refer.getSoundSystem();
            sndSystem.newStreamingSource(true, this.sourceName, poolEntry.b, this.path, true, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            sndSystem.setTemporary(this.sourceName, false);
            sndSystem.setPitch(this.sourceName, this.pitch);
            sndSystem.setLooping(this.sourceName, true);
            sndSystem.activate(this.sourceName);
        }
        this.isInitialized = true;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setPlaybackVolumeMod(float playbackVolume) {
        this.playbackVolume = playbackVolume;
        if (this.isInitialized) {
            this.evaluateAndApplyVolume();
        }
    }

    private void evaluateAndApplyVolume() {
        if (!this.isInitialized) {
            return;
        }
        float volume = this.playbackVolume * this.volume;
        this.refer.getSoundSystem().setVolume(this.sourceName, volume);
    }

    public void stopStreaming(float fadeDuration) {
        SoundSystem sndSystem = this.refer.getSoundSystem();
        if (fadeDuration <= 0.0f) {
            sndSystem.stop(this.sourceName);
        } else {
            sndSystem.fadeOut(this.sourceName, null, (long)fadeDuration * 1000L);
        }
    }

    public void pauseStreaming() {
        SoundSystem sndSystem = this.refer.getSoundSystem();
        sndSystem.pause(this.sourceName);
        this.isPaused = true;
    }

    public void interruptStreaming() {
        SoundSystem sndSystem = this.refer.getSoundSystem();
        sndSystem.stop(this.sourceName);
    }

    public void unallocate() {
        if (!this.isInitialized) {
            return;
        }
        SoundSystem sndSystem = this.refer.getSoundSystem();
        this.interruptStreaming();
        sndSystem.removeSource(this.sourceName);
    }
}

