/*
 * Decompiled with CFR 0.152.
 */
public class TextureHDWaterFX
extends bdg
implements TextureHDFX {
    private bem texturePackBase;
    private int tileWidth = 16;
    protected float[] buf1;
    protected float[] buf2;
    protected float[] buf3;
    protected float[] buf4;
    private int tickCounter;

    public TextureHDWaterFX() {
        super(amq.D.cl);
        this.d = new byte[this.tileWidth * this.tileWidth * 4];
        this.buf1 = new float[this.tileWidth * this.tileWidth];
        this.buf2 = new float[this.tileWidth * this.tileWidth];
        this.buf3 = new float[this.tileWidth * this.tileWidth];
        this.buf4 = new float[this.tileWidth * this.tileWidth];
        this.tickCounter = 0;
    }

    public void setTileWidth(int tileWidth) {
        if (tileWidth > Config.getMaxDynamicTileWidth()) {
            tileWidth = Config.getMaxDynamicTileWidth();
        }
        this.tileWidth = tileWidth;
        this.d = new byte[tileWidth * tileWidth * 4];
        this.buf1 = new float[tileWidth * tileWidth];
        this.buf2 = new float[tileWidth * tileWidth];
        this.buf3 = new float[tileWidth * tileWidth];
        this.buf4 = new float[tileWidth * tileWidth];
        this.tickCounter = 0;
    }

    public void setTexturePackBase(bem tpb) {
        this.texturePackBase = tpb;
    }

    public void a() {
        if (!Config.isAnimatedWater()) {
            this.d = null;
        }
        if (this.d == null) {
            return;
        }
        ++this.tickCounter;
        int widthMask = this.tileWidth - 1;
        for (int y2 = 0; y2 < this.tileWidth; ++y2) {
            for (int x2 = 0; x2 < this.tileWidth; ++x2) {
                float f2 = 0.0f;
                for (int s2 = y2 - 1; s2 <= y2 + 1; ++s2) {
                    int tx2 = s2 & widthMask;
                    int ty2 = x2 & widthMask;
                    f2 += this.buf1[tx2 + ty2 * this.tileWidth];
                }
                this.buf2[y2 + x2 * this.tileWidth] = f2 / 3.3f + this.buf3[y2 + x2 * this.tileWidth] * 0.8f;
            }
        }
        for (int j2 = 0; j2 < this.tileWidth; ++j2) {
            for (int l2 = 0; l2 < this.tileWidth; ++l2) {
                int n2 = j2 + l2 * this.tileWidth;
                this.buf3[n2] = this.buf3[n2] + this.buf4[j2 + l2 * this.tileWidth] * 0.05f;
                if (this.buf3[j2 + l2 * this.tileWidth] < 0.0f) {
                    this.buf3[j2 + l2 * this.tileWidth] = 0.0f;
                }
                int n3 = j2 + l2 * this.tileWidth;
                this.buf4[n3] = this.buf4[n3] - 0.1f;
                if (!(Math.random() < 0.05)) continue;
                this.buf4[j2 + l2 * this.tileWidth] = 0.5f;
            }
        }
        float[] af2 = this.buf2;
        this.buf2 = this.buf1;
        this.buf1 = af2;
        for (int i2 = 0; i2 < this.tileWidth * this.tileWidth; ++i2) {
            float f1 = this.buf1[i2];
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            float f2 = f1 * f1;
            int r2 = (int)(32.0f + f2 * 32.0f);
            int g2 = (int)(50.0f + f2 * 64.0f);
            int b2 = 255;
            int a2 = (int)(146.0f + f2 * 50.0f);
            if (this.f) {
                int i3 = (r2 * 30 + g2 * 59 + b2 * 11) / 100;
                int j3 = (r2 * 30 + g2 * 70) / 100;
                int k3 = (r2 * 30 + b2 * 70) / 100;
                r2 = i3;
                g2 = j3;
                b2 = k3;
            }
            this.d[i2 * 4 + 0] = (byte)r2;
            this.d[i2 * 4 + 1] = (byte)g2;
            this.d[i2 * 4 + 2] = (byte)b2;
            this.d[i2 * 4 + 3] = (byte)a2;
        }
    }
}

