/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Knowledge;
import eu.ha3.matmos.engine.Switchable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;

public class Dynamic
extends Switchable {
    private List sheets = new ArrayList();
    private List keys = new ArrayList();
    public int value = 0;

    public Dynamic(Knowledge knowledgeIn) {
        super(knowledgeIn);
    }

    public void addCouple(String sheet, int key) {
        this.sheets.add(sheet);
        this.keys.add(key);
        this.flagNeedsTesting();
    }

    public void removeCouple(int id) {
        this.sheets.remove(id);
        this.keys.remove(id);
        this.flagNeedsTesting();
    }

    public void setSheet(int id, String sheet) {
        this.sheets.set(id, sheet);
        this.flagNeedsTesting();
    }

    public void setKey(int id, int key) {
        this.keys.set(id, key);
        this.flagNeedsTesting();
    }

    public List getSheets() {
        return this.sheets;
    }

    public List getKeys() {
        return this.keys;
    }

    public String getSheet(int id) {
        return (String)this.sheets.get(id);
    }

    public int getKey(int id) {
        return (Integer)this.keys.get(id);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    public void evaluate() {
        this.value = 0;
        if (!this.isValid()) {
            return;
        }
        Iterator iterSheets = this.sheets.iterator();
        Iterator iterKeys = this.keys.iterator();
        while (iterSheets.hasNext()) {
            String sheet = (String)iterSheets.next();
            Integer key = (Integer)iterKeys.next();
            this.value += ((Integer)((ArrayList)this.knowledge.data.sheets.get(sheet)).get(key)).intValue();
        }
    }

    @Override
    protected boolean testIfValid() {
        Iterator iterSheets = this.sheets.iterator();
        Iterator iterKeys = this.keys.iterator();
        while (iterSheets.hasNext()) {
            String sheet = (String)iterSheets.next();
            Integer key = (Integer)iterKeys.next();
            if (this.knowledge.data.sheets.containsKey(sheet)) {
                if (key >= 0 && key < ((ArrayList)this.knowledge.data.sheets.get(sheet)).size()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String serialize(XMLEventWriter eventWriter) throws XMLStreamException {
        this.buildDescriptibleSerialized(eventWriter);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        DTD tab = eventFactory.createDTD("\t");
        DTD ret = eventFactory.createDTD("\n");
        for (int i2 = 0; i2 < this.sheets.size(); ++i2) {
            eventWriter.add(tab);
            eventWriter.add(eventFactory.createStartElement("", "", "entry"));
            eventWriter.add(eventFactory.createAttribute("sheet", (String)this.sheets.get(i2)));
            eventWriter.add(eventFactory.createCharacters(this.keys.get(i2) + ""));
            eventWriter.add(eventFactory.createEndElement("", "", "entry"));
            eventWriter.add(ret);
        }
        return null;
    }
}

