/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Descriptible;
import eu.ha3.matmos.engine.Knowledge;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class Event
extends Descriptible {
    Knowledge knowledge;
    public ArrayList paths = new ArrayList();
    public float volMin;
    public float volMax;
    public float pitchMin;
    public float pitchMax;
    public int metaSound;

    Event(Knowledge knowledgeIn) {
        this.knowledge = knowledgeIn;
        this.volMin = 1.0f;
        this.volMax = 1.0f;
        this.pitchMin = 1.0f;
        this.pitchMax = 1.0f;
        this.metaSound = 0;
    }

    void setKnowledge(Knowledge knowledgeIn) {
        this.knowledge = knowledgeIn;
    }

    public void cacheSounds() {
        Iterator iter = this.paths.iterator();
        while (iter.hasNext()) {
            this.knowledge.soundManager.cacheSound((String)iter.next());
        }
    }

    public void playSound(float volMod, float pitchMod) {
        if (this.paths.isEmpty()) {
            return;
        }
        float volume = this.volMax - this.volMin;
        float pitch = this.pitchMax - this.pitchMin;
        volume = this.volMin + (volume > 0.0f ? this.knowledge.random.nextFloat() * volume : 0.0f);
        pitch = this.pitchMin + (pitch > 0.0f ? this.knowledge.random.nextFloat() * pitch : 0.0f);
        String path = (String)this.paths.get(this.knowledge.random.nextInt(this.paths.size()));
        this.knowledge.soundManager.playSound(path, volume *= volMod, pitch *= pitchMod, this.metaSound);
    }

    @Override
    public String serialize(XMLEventWriter eventWriter) throws XMLStreamException {
        this.buildDescriptibleSerialized(eventWriter);
        Iterator iter = this.paths.iterator();
        while (iter.hasNext()) {
            this.createNode(eventWriter, "path", (String)iter.next());
        }
        this.createNode(eventWriter, "volmin", this.volMin + "");
        this.createNode(eventWriter, "volmax", this.volMax + "");
        this.createNode(eventWriter, "pitchmin", this.pitchMin + "");
        this.createNode(eventWriter, "pitchmax", this.pitchMax + "");
        this.createNode(eventWriter, "metasound", this.metaSound + "");
        return "";
    }
}

