/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Condition;
import eu.ha3.matmos.engine.ConditionSet;
import eu.ha3.matmos.engine.Data;
import eu.ha3.matmos.engine.Dynamic;
import eu.ha3.matmos.engine.Event;
import eu.ha3.matmos.engine.Machine;
import eu.ha3.matmos.engine.RunningClock;
import eu.ha3.matmos.engine.SoundRelay;
import eu.ha3.matmos.engine.SugarList;
import eu.ha3.matmos.engine.TimedEvent;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;
import javax.xml.transform.stream.StreamResult;

public class Knowledge {
    LinkedHashMap dynamics;
    LinkedHashMap lists;
    LinkedHashMap conditions;
    LinkedHashMap sets;
    LinkedHashMap machines;
    LinkedHashMap events;
    Data data = new Data();
    SoundRelay soundManager = null;
    RunningClock clock;
    private boolean isRunning = false;
    int dataLastVersion = 0;
    Random random = new Random(System.currentTimeMillis());

    public Knowledge() {
        this.clock = new RunningClock();
        this.patchKnowledge();
    }

    public void patchKnowledge() {
        this.turnOff();
        this.dynamics = new LinkedHashMap();
        this.lists = new LinkedHashMap();
        this.conditions = new LinkedHashMap();
        this.sets = new LinkedHashMap();
        this.machines = new LinkedHashMap();
        this.events = new LinkedHashMap();
    }

    public void turnOn() {
        if (this.soundManager == null) {
            return;
        }
        if (this.isRunning) {
            return;
        }
        this.reclaimKeyring();
        this.isRunning = true;
        for (Machine machine : this.machines.values()) {
            machine.powerOn();
        }
    }

    public void turnOff() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        for (Machine machine : this.machines.values()) {
            machine.powerOff();
        }
    }

    public boolean isTurnedOn() {
        return this.isRunning;
    }

    public Set getDynamicsKeySet() {
        return this.dynamics.keySet();
    }

    public Set getListsKeySet() {
        return this.lists.keySet();
    }

    public Set getConditionsKeySet() {
        return this.conditions.keySet();
    }

    public Set getConditionSetsKeySet() {
        return this.sets.keySet();
    }

    public Set getMachinesKeySet() {
        return this.machines.keySet();
    }

    public Set getEventsKeySet() {
        return this.events.keySet();
    }

    public void reclaimKeyring() {
        this.turnOff();
        for (Dynamic dynamic : this.dynamics.values()) {
            dynamic.setKnowledge(this);
        }
        for (Condition condition : this.conditions.values()) {
            condition.setKnowledge(this);
        }
        for (ConditionSet cset : this.sets.values()) {
            cset.setKnowledge(this);
        }
        for (Machine machine : this.machines.values()) {
            machine.setKnowledge(this);
        }
        for (Event event : this.events.values()) {
            event.setKnowledge(this);
        }
    }

    public void retreiveKeyring(Knowledge originalKnowledge) {
        if (originalKnowledge.isRunning) {
            return;
        }
        this.dynamics = (LinkedHashMap)originalKnowledge.dynamics.clone();
        this.lists = (LinkedHashMap)originalKnowledge.lists.clone();
        this.conditions = (LinkedHashMap)originalKnowledge.conditions.clone();
        this.sets = (LinkedHashMap)originalKnowledge.sets.clone();
        this.machines = (LinkedHashMap)originalKnowledge.machines.clone();
        this.events = (LinkedHashMap)originalKnowledge.events.clone();
        this.reclaimKeyring();
    }

    public int purgeUnused() {
        int purgedTotal = 0;
        HashSet<String> toPurge = new HashSet<String>();
        toPurge.clear();
        for (String string : this.sets.keySet()) {
            toPurge.add(string);
        }
        for (Machine machine : this.machines.values()) {
            for (String keepable : machine.getAllows()) {
                toPurge.remove(keepable);
            }
            for (String keepable : machine.getRestricts()) {
                toPurge.remove(keepable);
            }
        }
        for (String string : toPurge) {
            ++purgedTotal;
            this.removeConditionSet(string);
        }
        toPurge.clear();
        for (String string : this.conditions.keySet()) {
            toPurge.add(string);
        }
        for (ConditionSet conditionSet : this.sets.values()) {
            for (String keepable : conditionSet.getSet().keySet()) {
                toPurge.remove(keepable);
            }
        }
        for (String string : toPurge) {
            ++purgedTotal;
            this.removeCondition(string);
        }
        toPurge.clear();
        for (String string : this.lists.keySet()) {
            toPurge.add(string);
        }
        for (Condition condition : this.conditions.values()) {
            if (condition.getList() == null || condition.getList() == "") continue;
            toPurge.remove(condition.getList());
        }
        for (String string : toPurge) {
            ++purgedTotal;
            this.removeList(string);
        }
        return purgedTotal;
    }

    public void setSoundManager(SoundRelay soundManagerIn) {
        this.soundManager = soundManagerIn;
    }

    public void cacheSounds() {
        for (Event event : this.events.values()) {
            event.cacheSounds();
        }
    }

    public void setClock(RunningClock clockIn) {
        this.clock = clockIn;
    }

    public void setData(Data dataIn) {
        this.data = dataIn;
        this.applySheetFlagNeedsTesting();
    }

    public long getTimeMillis() {
        return this.clock.getMilliseconds();
    }

    void applySheetFlagNeedsTesting() {
        for (Condition condition : this.conditions.values()) {
            condition.flagNeedsTesting();
        }
        for (Dynamic dynamic : this.dynamics.values()) {
            dynamic.flagNeedsTesting();
        }
    }

    public Event getEvent(String name) {
        return (Event)this.events.get(name);
    }

    public boolean addEvent(String name) {
        if (this.events.containsKey(name)) {
            return false;
        }
        this.events.put(name, new Event(this));
        ((Event)this.events.get((Object)name)).nickname = name;
        return true;
    }

    public boolean removeEvent(String name) {
        if (!this.events.containsKey(name)) {
            return false;
        }
        this.events.remove(name);
        return true;
    }

    public boolean renameEvent(String name, String newName) {
        if (!this.events.containsKey(name)) {
            return false;
        }
        if (this.events.containsKey(newName)) {
            return false;
        }
        this.events.put(newName, this.events.get(name));
        this.events.remove(name);
        ((Event)this.events.get((Object)newName)).nickname = newName;
        for (Machine machine : this.machines.values()) {
            for (TimedEvent etime : machine.getTimedEvents()) {
                if (!etime.event.equals(name)) continue;
                etime.event = newName;
            }
        }
        return true;
    }

    void applyDynamicFlagNeedsTesting() {
        for (Condition condition : this.conditions.values()) {
            condition.flagNeedsTesting();
        }
    }

    public Dynamic getDynamic(String name) {
        return (Dynamic)this.dynamics.get(name);
    }

    public boolean addDynamic(String name) {
        if (this.dynamics.containsKey(name)) {
            return false;
        }
        this.dynamics.put(name, new Dynamic(this));
        ((Dynamic)this.dynamics.get((Object)name)).nickname = name;
        this.applyDynamicFlagNeedsTesting();
        return true;
    }

    public boolean removeDynamic(String name) {
        if (!this.dynamics.containsKey(name)) {
            return false;
        }
        this.dynamics.remove(name);
        this.applyDynamicFlagNeedsTesting();
        return true;
    }

    public boolean renameDynamic(String name, String newName) {
        if (!this.dynamics.containsKey(name)) {
            return false;
        }
        if (this.dynamics.containsKey(newName)) {
            return false;
        }
        this.dynamics.put(newName, this.dynamics.get(name));
        this.dynamics.remove(name);
        ((Dynamic)this.dynamics.get((Object)newName)).nickname = newName;
        for (Condition condition : this.conditions.values()) {
            condition.replaceDynamicName(name, newName);
        }
        return true;
    }

    void applyListFlagNeedsTesting() {
        for (Condition condition : this.conditions.values()) {
            condition.flagNeedsTesting();
        }
    }

    public SugarList getList(String name) {
        return (SugarList)this.lists.get(name);
    }

    public boolean addList(String name) {
        if (this.lists.containsKey(name)) {
            return false;
        }
        this.lists.put(name, new SugarList());
        ((SugarList)this.lists.get((Object)name)).nickname = name;
        this.applyDynamicFlagNeedsTesting();
        return true;
    }

    public boolean removeList(String name) {
        if (!this.lists.containsKey(name)) {
            return false;
        }
        this.lists.remove(name);
        this.applyDynamicFlagNeedsTesting();
        return true;
    }

    public boolean renameList(String name, String newName) {
        if (!this.lists.containsKey(name)) {
            return false;
        }
        if (this.lists.containsKey(newName)) {
            return false;
        }
        this.lists.put(newName, this.lists.get(name));
        this.lists.remove(name);
        ((SugarList)this.lists.get((Object)newName)).nickname = newName;
        for (Condition condition : this.conditions.values()) {
            condition.replaceListName(name, newName);
        }
        return true;
    }

    void applyConditionNeedsTesting() {
        for (ConditionSet cset : this.sets.values()) {
            cset.flagNeedsTesting();
        }
    }

    public Condition getCondition(String name) {
        return (Condition)this.conditions.get(name);
    }

    public boolean addCondition(String name) {
        if (this.conditions.containsKey(name)) {
            return false;
        }
        this.conditions.put(name, new Condition(this));
        ((Condition)this.conditions.get((Object)name)).nickname = name;
        this.applyConditionNeedsTesting();
        return true;
    }

    public boolean renameCondition(String name, String newName) {
        if (!this.conditions.containsKey(name)) {
            return false;
        }
        if (this.conditions.containsKey(newName)) {
            return false;
        }
        this.conditions.put(newName, this.conditions.get(name));
        this.conditions.remove(name);
        ((Condition)this.conditions.get((Object)newName)).nickname = newName;
        for (ConditionSet cset : this.sets.values()) {
            cset.replaceConditionName(name, newName);
        }
        this.applyConditionNeedsTesting();
        return true;
    }

    public boolean removeCondition(String name) {
        if (!this.conditions.containsKey(name)) {
            return false;
        }
        this.conditions.remove(name);
        this.applyConditionNeedsTesting();
        return true;
    }

    void applyConditionSetNeedsTesting() {
        for (Machine machine : this.machines.values()) {
            machine.flagNeedsTesting();
        }
    }

    public ConditionSet getConditionSet(String name) {
        return (ConditionSet)this.sets.get(name);
    }

    public boolean addConditionSet(String name) {
        if (this.sets.containsKey(name)) {
            return false;
        }
        this.sets.put(name, new ConditionSet(this));
        ((ConditionSet)this.sets.get((Object)name)).nickname = name;
        this.applyConditionSetNeedsTesting();
        return true;
    }

    public boolean renameConditionSet(String name, String newName) {
        if (!this.sets.containsKey(name)) {
            return false;
        }
        if (this.sets.containsKey(newName)) {
            return false;
        }
        this.sets.put(newName, this.sets.get(name));
        this.sets.remove(name);
        ((ConditionSet)this.sets.get((Object)newName)).nickname = newName;
        for (Machine machine : this.machines.values()) {
            machine.replaceSetName(name, newName);
        }
        this.applyConditionSetNeedsTesting();
        return true;
    }

    public boolean removeConditionSet(String name) {
        if (!this.sets.containsKey(name)) {
            return false;
        }
        this.sets.remove(name);
        this.applyConditionSetNeedsTesting();
        return true;
    }

    void applyMachineNeedsTesting() {
    }

    public Machine getMachine(String name) {
        return (Machine)this.machines.get(name);
    }

    public boolean addMachine(String name) {
        if (this.machines.containsKey(name)) {
            return false;
        }
        this.machines.put(name, new Machine(this));
        ((Machine)this.machines.get((Object)name)).nickname = name;
        this.applyMachineNeedsTesting();
        return true;
    }

    public boolean removeMachine(String name) {
        if (!this.machines.containsKey(name)) {
            return false;
        }
        this.machines.remove(name);
        this.applyMachineNeedsTesting();
        return true;
    }

    public boolean renameMachine(String name, String newName) {
        if (!this.machines.containsKey(name)) {
            return false;
        }
        if (this.machines.containsKey(newName)) {
            return false;
        }
        this.machines.put(newName, this.machines.get(name));
        this.machines.remove(name);
        ((Machine)this.machines.get((Object)newName)).nickname = newName;
        this.applyConditionSetNeedsTesting();
        return true;
    }

    public void routine() {
        if (!this.isRunning) {
            return;
        }
        if (this.dataLastVersion != this.data.updateVersion) {
            this.evaluate();
            this.dataLastVersion = this.data.updateVersion;
        }
        this.soundManager.routine();
        Iterator iter = this.machines.values().iterator();
        while (iter.hasNext()) {
            ((Machine)iter.next()).routine();
        }
    }

    public void soundRoutine() {
        if (!this.isRunning) {
            return;
        }
        this.soundManager.routine();
        Iterator iter = this.machines.values().iterator();
        while (iter.hasNext()) {
            ((Machine)iter.next()).routine();
        }
    }

    public void dataRoutine() {
        if (!this.isRunning) {
            return;
        }
        if (this.dataLastVersion != this.data.updateVersion) {
            this.evaluate();
            this.dataLastVersion = this.data.updateVersion;
        }
    }

    void evaluate() {
        if (!this.isRunning) {
            return;
        }
        for (Dynamic dynamic : this.dynamics.values()) {
            dynamic.evaluate();
        }
        for (Condition condition : this.conditions.values()) {
            condition.evaluate();
        }
        for (ConditionSet cset : this.sets.values()) {
            cset.evaluate();
        }
        for (Machine machine : this.machines.values()) {
            machine.evaluate();
        }
    }

    public String createXML() throws XMLStreamException {
        String name;
        int i2;
        StreamResult serialized = new StreamResult(new StringWriter());
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        XMLEventWriter eventWriter = outputFactory.createXMLEventWriter(serialized);
        DTD ret = eventFactory.createDTD("\n");
        DTD end = eventFactory.createDTD("\n");
        eventWriter.add(eventFactory.createStartDocument());
        eventWriter.add(ret);
        eventWriter.add(eventFactory.createStartElement("", "", "contents"));
        Object[] keysArray = this.dynamics.keySet().toArray();
        Arrays.sort(keysArray);
        for (i2 = 0; i2 < keysArray.length; ++i2) {
            name = keysArray[i2].toString();
            eventWriter.add(ret);
            eventWriter.add(eventFactory.createStartElement("", "", "dynamic"));
            eventWriter.add(eventFactory.createAttribute("name", name));
            eventWriter.add(ret);
            ((Dynamic)this.dynamics.get(name)).serialize(eventWriter);
            eventWriter.add(eventFactory.createEndElement("", "", "dynamic"));
        }
        keysArray = this.lists.keySet().toArray();
        Arrays.sort(keysArray);
        for (i2 = 0; i2 < keysArray.length; ++i2) {
            name = keysArray[i2].toString();
            eventWriter.add(ret);
            eventWriter.add(eventFactory.createStartElement("", "", "list"));
            eventWriter.add(eventFactory.createAttribute("name", name));
            eventWriter.add(ret);
            ((SugarList)this.lists.get(name)).serialize(eventWriter);
            eventWriter.add(eventFactory.createEndElement("", "", "list"));
        }
        keysArray = this.conditions.keySet().toArray();
        Arrays.sort(keysArray);
        for (i2 = 0; i2 < keysArray.length; ++i2) {
            name = keysArray[i2].toString();
            eventWriter.add(ret);
            eventWriter.add(eventFactory.createStartElement("", "", "condition"));
            eventWriter.add(eventFactory.createAttribute("name", name));
            eventWriter.add(ret);
            ((Condition)this.conditions.get(name)).serialize(eventWriter);
            eventWriter.add(eventFactory.createEndElement("", "", "condition"));
        }
        keysArray = this.sets.keySet().toArray();
        Arrays.sort(keysArray);
        for (i2 = 0; i2 < keysArray.length; ++i2) {
            name = keysArray[i2].toString();
            eventWriter.add(ret);
            eventWriter.add(eventFactory.createStartElement("", "", "set"));
            eventWriter.add(eventFactory.createAttribute("name", name));
            eventWriter.add(ret);
            ((ConditionSet)this.sets.get(name)).serialize(eventWriter);
            eventWriter.add(eventFactory.createEndElement("", "", "set"));
        }
        keysArray = this.events.keySet().toArray();
        Arrays.sort(keysArray);
        for (i2 = 0; i2 < keysArray.length; ++i2) {
            name = keysArray[i2].toString();
            eventWriter.add(ret);
            eventWriter.add(eventFactory.createStartElement("", "", "event"));
            eventWriter.add(eventFactory.createAttribute("name", name));
            eventWriter.add(ret);
            ((Event)this.events.get(name)).serialize(eventWriter);
            eventWriter.add(eventFactory.createEndElement("", "", "event"));
        }
        keysArray = this.machines.keySet().toArray();
        Arrays.sort(keysArray);
        for (i2 = 0; i2 < keysArray.length; ++i2) {
            name = keysArray[i2].toString();
            eventWriter.add(ret);
            eventWriter.add(eventFactory.createStartElement("", "", "machine"));
            eventWriter.add(eventFactory.createAttribute("name", name));
            eventWriter.add(ret);
            ((Machine)this.machines.get(name)).serialize(eventWriter);
            eventWriter.add(eventFactory.createEndElement("", "", "machine"));
        }
        eventWriter.add(ret);
        eventWriter.add(eventFactory.createEndElement("", "", "contents"));
        eventWriter.add(end);
        eventWriter.add(eventFactory.createEndDocument());
        eventWriter.close();
        return serialized.getWriter().toString();
    }
}

