/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.util.property.simple;

import eu.ha3.util.property.contract.PropertyHolder;
import eu.ha3.util.property.simple.PropertyMissingException;
import eu.ha3.util.property.simple.PropertyTypeException;
import java.util.HashMap;
import java.util.Map;

public class PropertyCell
implements PropertyHolder {
    private Map properties = new HashMap();

    @Override
    public String getString(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        return (String)this.properties.get(name);
    }

    @Override
    public boolean getBoolean(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Boolean.parseBoolean((String)this.properties.get(name));
        }
        catch (NumberFormatException e2) {
            throw new PropertyTypeException();
        }
    }

    @Override
    public int getInteger(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Integer.parseInt((String)this.properties.get(name));
        }
        catch (NumberFormatException e2) {
            throw new PropertyTypeException();
        }
    }

    @Override
    public float getFloat(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Float.parseFloat((String)this.properties.get(name));
        }
        catch (NumberFormatException e2) {
            throw new PropertyTypeException();
        }
    }

    @Override
    public long getLong(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Long.parseLong((String)this.properties.get(name));
        }
        catch (NumberFormatException e2) {
            throw new PropertyTypeException();
        }
    }

    @Override
    public double getDouble(String name) {
        if (!this.properties.containsKey(name)) {
            throw new PropertyMissingException();
        }
        try {
            return Double.parseDouble((String)this.properties.get(name));
        }
        catch (NumberFormatException e2) {
            throw new PropertyTypeException();
        }
    }

    @Override
    public void setProperty(String name, Object o2) {
        this.properties.put(name, o2.toString());
    }

    @Override
    public Map getAllProperties() {
        return this.properties;
    }
}

