/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Splitter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class ConfigCategory
implements Map {
    private String name;
    private String comment;
    private ArrayList children = new ArrayList();
    private Map properties = new TreeMap();
    public final ConfigCategory parent;

    public ConfigCategory(String name) {
        this(name, null);
    }

    public ConfigCategory(String name, ConfigCategory parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigCategory) {
            ConfigCategory cat = (ConfigCategory)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getQualifiedName() {
        return ConfigCategory.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, ConfigCategory parent) {
        return parent == null ? name : parent.getQualifiedName() + "." + name;
    }

    public ConfigCategory getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map getValues() {
        return this.properties;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Property get(String key) {
        return (Property)this.properties.get(key);
    }

    public void set(String key, Property value) {
        this.properties.put(key, value);
    }

    public void write(BufferedWriter out, int indent) throws IOException {
        String pad = this.getIndent(indent);
        out.write(pad + "####################" + Configuration.NEW_LINE);
        out.write(pad + "# " + this.name + Configuration.NEW_LINE);
        if (this.comment != null) {
            out.write(pad + "#===================" + Configuration.NEW_LINE);
            Splitter splitter = Splitter.onPattern((String)"\r?\n");
            for (String line : splitter.split((CharSequence)this.comment)) {
                out.write(pad + "# " + line + Configuration.NEW_LINE);
            }
        }
        out.write(pad + "####################" + Configuration.NEW_LINE + Configuration.NEW_LINE);
        if (!Configuration.allowedProperties.matchesAllOf((CharSequence)this.name)) {
            this.name = '\"' + this.name + '\"';
        }
        out.write(pad + this.name + " {" + Configuration.NEW_LINE);
        pad = this.getIndent(indent + 1);
        Property[] props = this.properties.values().toArray(new Property[this.properties.size()]);
        for (int x2 = 0; x2 < props.length; ++x2) {
            String propName;
            Property prop = props[x2];
            if (prop.comment != null) {
                if (x2 != 0) {
                    out.newLine();
                }
                Splitter splitter = Splitter.onPattern((String)"\r?\n");
                for (String commentLine : splitter.split((CharSequence)prop.comment)) {
                    out.write(pad + "# " + commentLine + Configuration.NEW_LINE);
                }
            }
            if (!Configuration.allowedProperties.matchesAllOf((CharSequence)(propName = prop.getName()))) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                out.write(String.format(pad + "%s:%s <" + Configuration.NEW_LINE, Character.valueOf(prop.getType().getID()), propName));
                pad = this.getIndent(indent + 2);
                for (String line : prop.valueList) {
                    out.write(pad + line + Configuration.NEW_LINE);
                }
                out.write(this.getIndent(indent + 1) + " >" + Configuration.NEW_LINE);
                continue;
            }
            if (prop.getType() == null) {
                out.write(String.format(pad + "%s=%s" + Configuration.NEW_LINE, propName, prop.value));
                continue;
            }
            out.write(String.format(pad + "%s:%s=%s" + Configuration.NEW_LINE, Character.valueOf(prop.getType().getID()), propName, prop.value));
        }
        for (ConfigCategory child : this.children) {
            child.write(out, indent + 1);
        }
        out.write(this.getIndent(indent) + "}" + Configuration.NEW_LINE + Configuration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder("");
        for (int x2 = 0; x2 < indent; ++x2) {
            buf.append("    ");
        }
        return buf.toString();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Property get(Object key) {
        return (Property)this.properties.get(key);
    }

    public Property put(String key, Property value) {
        return this.properties.put(key, value);
    }

    public Property remove(Object key) {
        return (Property)this.properties.remove(key);
    }

    public void putAll(Map m2) {
        this.properties.putAll(m2);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public Collection values() {
        return this.properties.values();
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }
}

