/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.Property;

public class ForgeDummyContainer
extends DummyModContainer
implements WorldAccessContainer {
    public static int clumpingThreshold = 64;

    public ForgeDummyContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "Forge";
        meta.name = "Minecraft Forge";
        meta.version = String.format("%d.%d.%d.%d", 6, 6, 2, 534);
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("LexManos", "Eloraam", "Spacetoad");
        meta.description = "Minecraft Forge is a common open source API allowing a broad range of mods to work cooperatively together. It allows many mods to be created without them editing the main Minecraft code.";
        meta.url = "http://MinecraftForge.net";
        meta.updateUrl = "http://MinecraftForge.net/forum/index.php/topic,5.0.html";
        meta.screenshots = new String[0];
        meta.logoFile = "/forge_logo.png";
        Configuration config = new Configuration(new File(Loader.instance().getConfigDir(), "forge.cfg"));
        if (!config.isChild) {
            config.load();
            Property enableGlobalCfg = config.get("general", "enableGlobalConfig", false);
            if (enableGlobalCfg.getBoolean(false)) {
                Configuration.enableGlobalConfig();
            }
        }
        Property clumpingThresholdProperty = config.get("general", "clumpingThreshold", 64);
        clumpingThresholdProperty.comment = "Controls the number threshold at which Packet51 is preferred over Packet52, default and minimum 64, maximum 1024";
        clumpingThreshold = clumpingThresholdProperty.getInt(64);
        if (clumpingThreshold > 1024 || clumpingThreshold < 64) {
            clumpingThreshold = 64;
            clumpingThresholdProperty.value = "64";
        }
        config.save();
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent evt) {
        ForgeChunkManager.captureConfig(evt.getModConfigurationDirectory());
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent evt) {
        ForgeChunkManager.loadConfiguration();
    }

    @Override
    public bq getDataForWriting(ahv handler, ahx info) {
        bq forgeData = new bq();
        bq dimData = DimensionManager.saveDimensionDataMap();
        forgeData.a("DimensionData", dimData);
        return forgeData;
    }

    public void readData(ahv handler, ahx info, Map propertyMap, bq tag) {
        if (tag.b("DimensionData")) {
            DimensionManager.loadDimensionDataMap(tag.b("DimensionData") ? tag.l("DimensionData") : null);
        }
    }
}

