/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;

public interface ISpecialArmor {
    public ArmorProperties getProperties(md var1, ur var2, lh var3, double var4, int var6);

    public int getArmorDisplay(qx var1, ur var2, int var3);

    public void damageArmor(md var1, ur var2, lh var3, int var4, int var5);

    public static class ArmorProperties
    implements Comparable {
        public int Priority = 0;
        public int AbsorbMax = Integer.MAX_VALUE;
        public double AbsorbRatio = 0.0;
        public int Slot = 0;
        private static final boolean DEBUG = false;

        public ArmorProperties(int priority, double ratio, int max) {
            this.Priority = priority;
            this.AbsorbRatio = ratio;
            this.AbsorbMax = max;
        }

        public static int ApplyArmor(md entity, ur[] inventory, lh source, double damage) {
            damage *= 25.0;
            ArrayList<ArmorProperties> dmgVals = new ArrayList<ArmorProperties>();
            for (int x2 = 0; x2 < inventory.length; ++x2) {
                Object armor;
                ur stack = inventory[x2];
                if (stack == null) continue;
                ArmorProperties prop = null;
                if (stack.b() instanceof ISpecialArmor) {
                    armor = (ISpecialArmor)((Object)stack.b());
                    prop = armor.getProperties(entity, stack, source, damage / 25.0, x2).copy();
                } else if (stack.b() instanceof su && !source.c()) {
                    armor = (su)stack.b();
                    prop = new ArmorProperties(0, (double)((su)armor).b / 25.0, ((up)armor).m() + 1 - stack.j());
                }
                if (prop == null) continue;
                prop.Slot = x2;
                dmgVals.add(prop);
            }
            if (dmgVals.size() > 0) {
                ArmorProperties[] props = dmgVals.toArray(new ArmorProperties[dmgVals.size()]);
                ArmorProperties.StandardizeList(props, damage);
                int level = props[0].Priority;
                double ratio = 0.0;
                for (ArmorProperties prop : props) {
                    if (level != prop.Priority) {
                        damage -= damage * ratio;
                        ratio = 0.0;
                        level = prop.Priority;
                    }
                    ratio += prop.AbsorbRatio;
                    double absorb = damage * prop.AbsorbRatio;
                    if (!(absorb > 0.0)) continue;
                    ur stack = inventory[prop.Slot];
                    int itemDamage = (int)(absorb / 25.0 < 1.0 ? 1.0 : absorb / 25.0);
                    if (stack.b() instanceof ISpecialArmor) {
                        ((ISpecialArmor)((Object)stack.b())).damageArmor(entity, stack, source, itemDamage, prop.Slot);
                    } else {
                        stack.a(itemDamage, entity);
                    }
                    if (stack.a > 0) continue;
                    inventory[prop.Slot] = null;
                }
                damage -= damage * ratio;
            }
            entity.aT = (int)(damage += (double)entity.aT) % 25;
            return (int)(damage / 25.0);
        }

        private static void StandardizeList(ArmorProperties[] armor, double damage) {
            Arrays.sort(armor);
            int start = 0;
            double total = 0.0;
            int priority = armor[0].Priority;
            int pStart = 0;
            boolean pChange = false;
            boolean pFinished = false;
            for (int x2 = 0; x2 < armor.length; ++x2) {
                int y2;
                total += armor[x2].AbsorbRatio;
                if (x2 != armor.length - 1 && armor[x2].Priority == priority) continue;
                if (armor[x2].Priority != priority) {
                    total -= armor[x2].AbsorbRatio;
                    --x2;
                    pChange = true;
                }
                if (total > 1.0) {
                    for (y2 = start; y2 <= x2; ++y2) {
                        double newRatio = armor[y2].AbsorbRatio / total;
                        if (newRatio * damage > (double)armor[y2].AbsorbMax) {
                            armor[y2].AbsorbRatio = (double)armor[y2].AbsorbMax / damage;
                            total = 0.0;
                            for (int z2 = pStart; z2 <= y2; ++z2) {
                                total += armor[z2].AbsorbRatio;
                            }
                            start = y2 + 1;
                            x2 = y2;
                            break;
                        }
                        armor[y2].AbsorbRatio = newRatio;
                        pFinished = true;
                    }
                    if (!pChange || !pFinished) continue;
                    damage -= damage * total;
                    total = 0.0;
                    start = x2 + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    pFinished = false;
                    if (!(damage <= 0.0)) continue;
                    for (y2 = x2 + 1; y2 < armor.length; ++y2) {
                        armor[y2].AbsorbRatio = 0.0;
                    }
                } else {
                    for (y2 = start; y2 <= x2; ++y2) {
                        total -= armor[y2].AbsorbRatio;
                        if (damage * armor[y2].AbsorbRatio > (double)armor[y2].AbsorbMax) {
                            armor[y2].AbsorbRatio = (double)armor[y2].AbsorbMax / damage;
                        }
                        total += armor[y2].AbsorbRatio;
                    }
                    damage -= damage * total;
                    total = 0.0;
                    if (x2 == armor.length - 1) continue;
                    start = x2 + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    if (!(damage <= 0.0)) continue;
                    for (y2 = x2 + 1; y2 < armor.length; ++y2) {
                        armor[y2].AbsorbRatio = 0.0;
                    }
                }
                break;
            }
        }

        public int compareTo(ArmorProperties o2) {
            if (o2.Priority != this.Priority) {
                return o2.Priority - this.Priority;
            }
            double left = this.AbsorbRatio == 0.0 ? 0.0 : (double)this.AbsorbMax * 100.0 / this.AbsorbRatio;
            double right = o2.AbsorbRatio == 0.0 ? 0.0 : (double)o2.AbsorbMax * 100.0 / o2.AbsorbRatio;
            return (int)(left - right);
        }

        public String toString() {
            return String.format("%d, %d, %f, %d", this.Priority, this.AbsorbMax, this.AbsorbRatio, this.AbsorbRatio == 0.0 ? 0 : (int)((double)this.AbsorbMax * 100.0 / this.AbsorbRatio));
        }

        public ArmorProperties copy() {
            return new ArmorProperties(this.Priority, this.AbsorbRatio, this.AbsorbMax);
        }
    }
}

