/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer _buf;
    private int _mark = -1;
    private boolean _isClosed = false;

    public ByteBufferInputStream(ByteBuffer buf) {
        this(buf, 0);
    }

    public ByteBufferInputStream(ByteBuffer buf, int off) {
        this._buf = buf;
        this._buf.position(off);
    }

    public int available() throws IOException {
        return this._buf.limit() - this._buf.position();
    }

    public void close() throws IOException {
        this._isClosed = true;
    }

    public synchronized void mark(int readlimit) {
        this._mark = this._buf.position();
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this._isClosed) {
            throw new IOException("stream is closed");
        }
        if (this.available() <= 0) {
            return -1;
        }
        return this._buf.get() & 0xFF;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this._isClosed) {
            throw new IOException("stream is closed");
        }
        int bytes = Math.min(len, this.available());
        if (bytes == 0) {
            return -1;
        }
        this._buf.get(b2, off, bytes);
        return bytes;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public synchronized void reset() throws IOException {
        if (this._mark < 0) {
            throw new IOException("mark not set");
        }
        this._buf.position(this._mark);
    }

    public long skip(long n2) throws IOException {
        int n22 = n2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n2;
        int n3 = Math.min(n22, this.available());
        int newPos = n3 + this._buf.position();
        this._buf.position(newPos);
        return n3;
    }
}

