/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombiningIterable<T>
implements Iterable<T> {
    private Iterable<T>[] _iterables;

    public CombiningIterable(Iterable<T> ... iterables) {
        this._iterables = iterables;
    }

    @Override
    public Iterator<T> iterator() {
        LinkedList<Iterator<Iterator<T>>> iterators = new LinkedList<Iterator<Iterator<T>>>();
        for (Iterable<T> iterable : this._iterables) {
            iterators.add(iterable.iterator());
        }
        return new CombiningIterator(iterators);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CombiningIterator<E>
    implements Iterator<E> {
        private LinkedList<Iterator<E>> _iterators;
        private Iterator<E> _curItx;

        public CombiningIterator(Iterator<E> ... iterators) {
            this._iterators = new LinkedList();
            for (Iterator<E> itx : iterators) {
                this._iterators.add(itx);
            }
        }

        public CombiningIterator(LinkedList<Iterator<E>> iterators) {
            this._iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            if (this._curItx != null && this._curItx.hasNext()) {
                return true;
            }
            if (this._iterators.size() == 0) {
                return false;
            }
            this._curItx = this._iterators.removeFirst();
            return this.hasNext();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this._curItx.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this._curItx != null) {
                this._curItx.remove();
            }
        }
    }
}

