/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;

public class CombiningInputStream
extends InputStream {
    private InputStream[] _constituents;
    private int _current;
    private int _marked = -1;
    private int _markLimit = -1;

    public CombiningInputStream(InputStream ... constituents) {
        this._constituents = constituents;
    }

    private boolean isEOF() {
        return this._current == this._constituents.length;
    }

    private boolean switchStreams() {
        ++this._current;
        if (!this.isEOF() && this._markLimit > 0) {
            this.getCurrent().mark(this._markLimit);
        }
        return this.isEOF();
    }

    private InputStream getCurrent() {
        return this.isEOF() ? null : this._constituents[this._current];
    }

    public int available() throws IOException {
        return this.isEOF() ? 0 : this.getCurrent().available();
    }

    public void close() throws IOException {
        IOException thrown = null;
        for (int ii2 = 0; ii2 < this._constituents.length; ++ii2) {
            try {
                this._constituents[ii2].close();
                continue;
            }
            catch (IOException e2) {
                thrown = e2;
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        int i2 = this.getCurrent().read();
        if (i2 < 0) {
            this.switchStreams();
            return this.read();
        }
        --this._markLimit;
        return i2;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        int total = 0;
        while (len > 0) {
            int read = this.getCurrent().read(b2, off, len);
            if (read < 0) {
                if (!this.switchStreams() && this.getCurrent().available() != 0) continue;
                break;
            }
            total += read;
            off += read;
            len -= read;
            this._markLimit -= read;
        }
        return total;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public boolean markSupported() {
        boolean supported = true;
        for (int ii2 = this._current; ii2 < this._constituents.length; ++ii2) {
            supported &= this._constituents[ii2].markSupported();
        }
        return supported;
    }

    public void mark(int readlimit) {
        if (!this.isEOF()) {
            this._marked = this._current;
            this._markLimit = readlimit;
            this.getCurrent().mark(readlimit);
        }
    }

    public void reset() throws IOException {
        if (this._marked < 0) {
            throw new IOException("no mark set");
        }
        if (this.isEOF()) {
            --this._current;
        }
        while (this._current > this._marked) {
            this.getCurrent().reset();
            --this._current;
        }
        this.getCurrent().reset();
    }

    public long skip(long n2) throws IOException {
        if (this.isEOF()) {
            return -1L;
        }
        long total = 0L;
        while (n2 > 0L && !this.isEOF()) {
            long bytes = this.getCurrent().skip(n2);
            if (bytes <= 0L) {
                int check = this.read();
                if (check < 0) break;
                bytes = 1L;
            }
            total += bytes;
            n2 -= bytes;
        }
        return total;
    }
}

