/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class TranslatingInputStream
extends InputStream {
    private InputStreamReader _delegate;
    private CharsetEncoder _encoder;
    private CharBuffer _charBuf;
    private ByteBuffer _byteBuf;

    public TranslatingInputStream(InputStream delegate, Charset from, Charset to2) {
        this._delegate = new InputStreamReader(delegate, from);
        this._encoder = to2.newEncoder();
        this._charBuf = CharBuffer.allocate(2);
        this._byteBuf = ByteBuffer.allocate(4);
        this._byteBuf.limit(0);
    }

    public TranslatingInputStream(InputStream delegate, Charset from, Charset to2, char replacement) {
        this(delegate, from, to2);
        this._encoder.replaceWith(TranslatingInputStream.encodeReplacement(to2, replacement));
        this._encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public int read() throws IOException {
        if (this._byteBuf.remaining() == 0) {
            this.fillBuffer();
        }
        if (this._byteBuf.remaining() == 0) {
            return -1;
        }
        return this._byteBuf.get() & 0xFF;
    }

    private static byte[] encodeReplacement(Charset to2, char replacement) {
        try {
            CharsetEncoder tempEncoder = to2.newEncoder();
            CharBuffer src = CharBuffer.wrap(new char[]{replacement});
            ByteBuffer dst = tempEncoder.encode(src);
            dst.position(0);
            byte[] result = new byte[dst.remaining()];
            dst.get(result);
            return result;
        }
        catch (CharacterCodingException e2) {
            throw new IllegalArgumentException("illegal replacement character: " + replacement);
        }
    }

    private void fillBuffer() throws IOException {
        this._byteBuf.clear();
        this._charBuf.clear();
        while (this._byteBuf.position() == 0) {
            this.fillCharBuf();
            if (this._charBuf.limit() == 0) {
                this._byteBuf.limit(0);
                return;
            }
            this._encoder.reset();
            CoderResult rslt = this._encoder.encode(this._charBuf, this._byteBuf, true);
            this._encoder.flush(this._byteBuf);
        }
        this._byteBuf.limit(this._byteBuf.position());
        this._byteBuf.position(0);
    }

    private void fillCharBuf() throws IOException {
        int limit = 0;
        int c2 = 0;
        do {
            if ((c2 = this._delegate.read()) < 0) continue;
            this._charBuf.put((char)c2);
            ++limit;
        } while (c2 >= 55296 && c2 <= 56319);
        this._charBuf.position(0);
        this._charBuf.limit(limit);
    }
}

