/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.lang;

import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtil {
    public static Number parse(String str, Class<? extends Number> klass) {
        if (klass == Byte.class || klass == Byte.TYPE) {
            return Byte.valueOf(str);
        }
        if (klass == Short.class || klass == Short.TYPE) {
            return Short.valueOf(str);
        }
        if (klass == Integer.class || klass == Integer.TYPE) {
            return Integer.valueOf(str);
        }
        if (klass == Long.class || klass == Long.TYPE) {
            return Long.valueOf(str);
        }
        if (klass == Float.class || klass == Float.TYPE) {
            return Float.valueOf(str);
        }
        if (klass == Double.class || klass == Double.TYPE) {
            return Double.valueOf(str);
        }
        if (klass == BigInteger.class) {
            return new BigInteger(str);
        }
        if (klass == BigDecimal.class) {
            return new BigDecimal(str);
        }
        throw new IllegalArgumentException("unknown class: " + klass.getName());
    }

    public static String toHexString(long value, int digits) {
        StringBuilder sb2 = new StringBuilder(digits);
        while (digits > 0) {
            int nibble = (int)(value & 0xFL);
            sb2.insert(0, "0123456789ABCDEF".charAt(nibble));
            value >>= 4;
            --digits;
        }
        return sb2.toString();
    }

    public static <T extends Number> T dynamicCast(Object obj, Class<T> klass) {
        if (obj == null) {
            return null;
        }
        Number src = (Number)obj;
        if (obj.getClass() == klass) {
            return (T)((Number)klass.cast(obj));
        }
        if (klass == Byte.class || klass == Byte.TYPE) {
            return (T)((Number)klass.cast(src.byteValue()));
        }
        if (klass == Short.class || klass == Short.TYPE) {
            return (T)((Number)klass.cast(src.byteValue()));
        }
        if (klass == Integer.class || klass == Integer.TYPE) {
            return (T)((Number)klass.cast(src.byteValue()));
        }
        if (klass == Long.class || klass == Long.TYPE) {
            return (T)((Number)klass.cast(src.byteValue()));
        }
        if (klass == Float.class || klass == Float.TYPE) {
            return (T)((Number)klass.cast(Float.valueOf(src.byteValue())));
        }
        if (klass == Double.class || klass == Double.TYPE) {
            return (T)((Number)klass.cast(src.byteValue()));
        }
        throw new ClassCastException("unsupported destination type: " + klass.getName());
    }
}

