/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.lang;

import java.io.UnsupportedEncodingException;
import java.util.Random;
import net.sf.kdgcommons.lang.NumberUtil;
import net.sf.kdgcommons.lang.StringCanon;

public class StringUtil {
    private static StringCanon _canon = new StringCanon();
    private static Random _RNG = new Random(System.currentTimeMillis());

    public static char lastChar(String str) {
        int index = str != null ? str.length() - 1 : -1;
        return index < 0 ? (char)'\u0000' : str.charAt(index);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            str = "";
        }
        for (int ii2 = 0; ii2 < str.length(); ++ii2) {
            if (Character.isWhitespace(str.charAt(ii2))) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() == 0) {
            return "";
        }
        if (!Character.isWhitespace(str.charAt(0)) && !Character.isWhitespace(str.charAt(str.length() - 1))) {
            return str;
        }
        StringBuilder sb2 = new StringBuilder(str);
        while (sb2.length() > 0 && Character.isWhitespace(sb2.charAt(0))) {
            sb2.deleteCharAt(0);
        }
        while (sb2.length() > 0 && Character.isWhitespace(sb2.charAt(sb2.length() - 1))) {
            sb2.deleteCharAt(sb2.length() - 1);
        }
        return sb2.toString();
    }

    public static String padLeft(String str, int len, char c2) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= len) {
            return str;
        }
        StringBuilder sb2 = new StringBuilder(len);
        for (int ii2 = len - str.length(); ii2 > 0; --ii2) {
            sb2.append(c2);
        }
        sb2.append(str);
        return sb2.toString();
    }

    public static String padRight(String str, int len, char c2) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= len) {
            return str;
        }
        StringBuilder sb2 = new StringBuilder(len);
        sb2.append(str);
        while (sb2.length() < len) {
            sb2.append(c2);
        }
        return sb2.toString();
    }

    public static boolean contains(String str, String segment) {
        if (str == null || segment == null) {
            return false;
        }
        if (segment.length() == 0) {
            return true;
        }
        return str.indexOf(segment) >= 0;
    }

    public static boolean containsIgnoreCase(String str, String segment) {
        if (str == null || segment == null) {
            return false;
        }
        return StringUtil.contains(str.toUpperCase(), segment.toUpperCase());
    }

    public static String repeat(char c2, int count) {
        char[] chars = new char[count];
        for (int ii2 = 0; ii2 < count; ++ii2) {
            chars[ii2] = c2;
        }
        return new String(chars);
    }

    public static byte[] toUTF8(String str) {
        try {
            if (str == null) {
                return new byte[0];
            }
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("UTF-8 not supported", e2);
        }
    }

    public static String fromUTF8(byte[] bytes) {
        try {
            if (bytes == null) {
                return "";
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("UTF-8 not supported", e2);
        }
    }

    public static String unicodeEscape(String src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb2 = new StringBuilder(src);
        for (int ii2 = 0; ii2 < sb2.length(); ++ii2) {
            char c2 = sb2.charAt(ii2);
            if (c2 >= ' ' && c2 <= '~' && c2 != '\\' && c2 != '\'' && c2 != '\"') continue;
            sb2.deleteCharAt(ii2);
            sb2.insert(ii2, NumberUtil.toHexString(c2, 4));
            sb2.insert(ii2, "\\u");
            ii2 += 5;
        }
        return sb2.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb2 = new StringBuilder(src);
        for (int ii2 = 0; ii2 < sb2.length(); ++ii2) {
            if (sb2.charAt(ii2) != '\\') continue;
            sb2.deleteCharAt(ii2);
            if (sb2.charAt(ii2) == 'u' || sb2.charAt(ii2) == 'U') {
                int c2 = (StringUtil.hex2dec(sb2.charAt(ii2 + 1)) << 12) + (StringUtil.hex2dec(sb2.charAt(ii2 + 2)) << 8) + (StringUtil.hex2dec(sb2.charAt(ii2 + 3)) << 4) + StringUtil.hex2dec(sb2.charAt(ii2 + 4));
                sb2.setCharAt(ii2, (char)c2);
                sb2.delete(ii2 + 1, ii2 + 5);
                continue;
            }
            if (sb2.charAt(ii2) == 'b') {
                sb2.setCharAt(ii2, '\b');
                continue;
            }
            if (sb2.charAt(ii2) == 't') {
                sb2.setCharAt(ii2, '\t');
                continue;
            }
            if (sb2.charAt(ii2) == 'n') {
                sb2.setCharAt(ii2, '\n');
                continue;
            }
            if (sb2.charAt(ii2) == 'f') {
                sb2.setCharAt(ii2, '\f');
                continue;
            }
            if (sb2.charAt(ii2) != 'r') continue;
            sb2.setCharAt(ii2, '\r');
        }
        return sb2.toString();
    }

    public static int parseDigit(char c2, int base) {
        int value = -1;
        if (c2 >= '0' && c2 <= '9') {
            value = c2 - 48;
        } else if (c2 >= 'a' && c2 <= 'z') {
            value = c2 - 97 + 10;
        } else if (c2 >= 'A' && c2 <= 'Z') {
            value = c2 - 65 + 10;
        }
        if (value >= base) {
            value = -1;
        }
        return value;
    }

    public static String intern(String str) {
        return _canon.intern(str);
    }

    public static String randomString(String chars, int minLength, int maxLength) {
        StringBuilder sb2 = new StringBuilder(maxLength);
        int len = minLength + _RNG.nextInt(maxLength - minLength + 1);
        for (int ii2 = 0; ii2 < len; ++ii2) {
            sb2.append(chars.charAt(_RNG.nextInt(chars.length())));
        }
        return sb2.toString();
    }

    public static String randomAlphaString(int minLength, int maxLength) {
        return StringUtil.randomString("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", minLength, maxLength);
    }

    public static String extractLeft(String source, String target) {
        if (source == null || target == null) {
            return "";
        }
        int idx = source.indexOf(target);
        if (idx < 0) {
            return "";
        }
        return source.substring(0, idx);
    }

    public static String extractRight(String source, String target) {
        if (source == null || target == null) {
            return "";
        }
        int idx = source.indexOf(target);
        if (idx < 0) {
            return "";
        }
        return source.substring(idx + target.length());
    }

    private static int hex2dec(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        throw new IllegalArgumentException("not a hex digit: " + c2);
    }
}

