/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.util;

import net.sf.kdgcommons.lang.UnreachableCodeException;
import net.sf.kdgcommons.util.ByteArray;

public class Base64Converter {
    private static char[] ENCODE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static int[] DECODE_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static boolean isBase64Char(char c2) {
        return c2 == '=' || DECODE_TABLE[c2 & 0xFF] >= 0;
    }

    public static int encode(byte[] src, int off, int len, byte[] dst, int doff) {
        int dlen = 0;
        while (len > 0) {
            Base64Converter.encodeGroup(src, off, len, dst, doff);
            len -= 3;
            off += 3;
            dlen += 4;
            doff += 4;
        }
        return dlen;
    }

    public static byte[] encode(byte[] src) {
        int dsize = (src.length + 2) / 3 * 4;
        byte[] dst = new byte[dsize];
        Base64Converter.encode(src, 0, src.length, dst, 0);
        return dst;
    }

    public static int decode(byte[] src, int off, int len, byte[] dst, int doff) {
        if (len % 4 != 0) {
            throw new IllegalArgumentException("source segment size is " + len + "; must be multiple of 4");
        }
        int dlen = 0;
        while (len > 0) {
            dlen += Base64Converter.decodeGroup(src, off, dst, doff + dlen);
            len -= 4;
            off += 4;
        }
        return dlen;
    }

    public static byte[] decode(byte[] src) {
        int dsize = src.length * 3 / 4;
        if (dsize == 0) {
            return new byte[0];
        }
        if (src[src.length - 1] == 61) {
            --dsize;
        }
        if (src[src.length - 2] == 61) {
            --dsize;
        }
        byte[] dst = new byte[dsize];
        Base64Converter.decode(src, 0, src.length, dst, 0);
        return dst;
    }

    public static byte[] decode(String src) {
        ByteArray out = new ByteArray(src.length(), 25);
        int inCnt = 0;
        byte[] inbuf = new byte[4];
        byte[] outbuf = new byte[3];
        for (int ii2 = 0; ii2 < src.length(); ++ii2) {
            char c2 = src.charAt(ii2);
            if (Base64Converter.isBase64Char(c2)) {
                inbuf[inCnt++] = (byte)c2;
            }
            if (inCnt != 4) continue;
            int len = Base64Converter.decodeGroup(inbuf, 0, outbuf, 0);
            out.add(outbuf, 0, len);
            inCnt = 0;
        }
        if (inCnt != 0) {
            throw new IllegalArgumentException("invalid encoded string: " + inCnt + " bytes left over");
        }
        return out.getBytes();
    }

    private static void encodeGroup(byte[] src, int off, int len, byte[] dst, int doff) {
        for (int ii2 = 0; ii2 < 4; ++ii2) {
            dst[doff + ii2] = 61;
        }
        len = len >= 3 ? 3 : len;
        int current = 0;
        int carry = 0;
        switch (len) {
            case 3: {
                current = src[off + 2] & 0x3F;
                carry = (src[off + 2] & 0xC0) >> 6;
                dst[doff + 3] = (byte)ENCODE_TABLE[current];
            }
            case 2: {
                current = carry | (src[off + 1] & 0xF) << 2;
                carry = (src[off + 1] & 0xF0) >> 4;
                dst[doff + 2] = (byte)ENCODE_TABLE[current];
            }
            case 1: {
                current = carry | (src[off + 0] & 3) << 4;
                dst[doff + 1] = (byte)ENCODE_TABLE[current];
                current = (src[off + 0] & 0xFC) >> 2;
                dst[doff + 0] = (byte)ENCODE_TABLE[current];
            }
            case 0: {
                break;
            }
            default: {
                throw new UnreachableCodeException("invalid encode length");
            }
        }
    }

    private static int decodeGroup(byte[] src, int off, byte[] dst, int doff) {
        for (int ii2 = 0; ii2 < 4; ++ii2) {
            int idx = off + ii2;
            char c2 = (char)src[idx];
            if (Base64Converter.isBase64Char(c2)) continue;
            throw new IllegalArgumentException("character at offset " + idx + " isn't Base64: " + c2);
        }
        int d0 = DECODE_TABLE[src[off + 0]];
        int d1 = DECODE_TABLE[src[off + 1]];
        int d2 = DECODE_TABLE[src[off + 2]];
        int d3 = DECODE_TABLE[src[off + 3]];
        dst[doff + 0] = (byte)(d0 << 2 | (d1 & 0x30) >> 4);
        if (d2 < 0) {
            return 1;
        }
        dst[doff + 1] = (byte)((d1 & 0xF) << 4 | (d2 & 0x3C) >> 2);
        if (d3 < 0) {
            return 2;
        }
        dst[doff + 2] = (byte)((d2 & 3) << 6 | d3);
        return 3;
    }
}

