/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.util;

import java.io.UnsupportedEncodingException;

public class ByteArray {
    protected byte[] _data;
    protected int _size;
    protected int _expandBy;

    public ByteArray(int capacity, int factor) {
        this._data = new byte[capacity];
        this._size = 0;
        this._expandBy = factor;
    }

    public ByteArray(byte[] src) {
        this(src.length * 5 / 4, 25);
        this.add(src);
    }

    public ByteArray(String src) {
        this(ByteArray.convertToISO8859(src));
    }

    public ByteArray(String src, String encoding) throws UnsupportedEncodingException {
        this(src.getBytes(encoding));
    }

    public ByteArray() {
        this(64, 25);
    }

    public void add(byte val) {
        this.ensureCapacity(1);
        this._data[this._size++] = val;
    }

    public void add(byte[] src) {
        this.add(src, 0, src.length);
    }

    public void add(byte[] src, int off, int len) {
        this.ensureCapacity(len);
        for (int ii2 = 0; ii2 < len; ++ii2) {
            this._data[this._size++] = src[off + ii2];
        }
    }

    public void add(char src) {
        this.add((byte)(src & 0xFF));
    }

    public void add(String src) {
        this.add(ByteArray.convertToISO8859(src));
    }

    public void add(String src, String encoding) throws UnsupportedEncodingException {
        this.add(src.getBytes(encoding));
    }

    public void add(ByteArray src) {
        this.ensureCapacity(src.size());
        for (int i2 = 0; i2 < src._size; ++i2) {
            this._data[this._size++] = src._data[i2];
        }
    }

    public byte get(int idx) {
        if (idx < 0 || idx >= this._size) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return this._data[idx];
    }

    public byte[] getArray() {
        return this._data;
    }

    public byte[] getBytes(int off, int len) {
        if (off < 0 || off > this._size) {
            throw new IllegalArgumentException("invalid offset: " + off);
        }
        if (off + len > this._size) {
            throw new IllegalArgumentException("invalid length: " + len);
        }
        byte[] result = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            result[i2] = this._data[off + i2];
        }
        return result;
    }

    public byte[] getBytes(int off) {
        return this.getBytes(off, this._size - off);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this._size);
    }

    public void insert(int off, ByteArray src) {
        this.insert(off, src, 0, src.size());
    }

    public void insert(int off, ByteArray src, int srcOff, int srcLen) {
        if (srcOff < 0 || srcOff > src.size()) {
            throw new IllegalArgumentException("invalid src offset: " + srcOff);
        }
        if (srcOff + srcLen > src.size()) {
            throw new IllegalArgumentException("invalid src length: " + srcLen);
        }
        this.insert(off, src.getArray(), srcOff, srcLen);
    }

    public void insert(int off, byte[] src) {
        this.insert(off, src, 0, src.length);
    }

    public void insert(int off, byte[] src, int srcOff, int srcLen) {
        if (off < 0 || off > this._size) {
            throw new IllegalArgumentException("invalid dst offset: " + off);
        }
        if (srcOff < 0 || srcOff > src.length) {
            throw new IllegalArgumentException("invalid src offset: " + srcOff);
        }
        if (srcOff + srcLen > src.length) {
            throw new IllegalArgumentException("invalid src length: " + srcLen);
        }
        this.ensureCapacity(srcLen);
        System.arraycopy(this._data, off, this._data, off + srcLen, this._size - off);
        System.arraycopy(src, srcOff, this._data, off, srcLen);
        this._size += srcLen;
    }

    public void remove(int idx) {
        this.remove(idx, 1);
    }

    public void remove(int off, int len) {
        if (off < 0 || off + len >= this._size) {
            throw new IllegalArgumentException("invalid offset/length: " + off + "/" + len);
        }
        int srcPos = off + len;
        int count = this._size - srcPos;
        System.arraycopy(this._data, srcPos, this._data, off, count);
        this._size -= len;
    }

    public void removeLast() {
        if (this._size > 0) {
            --this._size;
        }
    }

    public int size() {
        return this._size;
    }

    public void setSize(int size) {
        this.setCapacity(size);
        for (int ii2 = this._size; ii2 < size; ++ii2) {
            this._data[ii2] = 0;
        }
        this._size = size;
    }

    private static byte[] convertToISO8859(String src) {
        byte[] result = new byte[src.length()];
        for (int ii2 = 0; ii2 < result.length; ++ii2) {
            char c2 = src.charAt(ii2);
            if (c2 > '\u00ff') {
                throw new IllegalArgumentException("invalid character at position " + ii2);
            }
            result[ii2] = (byte)c2;
        }
        return result;
    }

    private void ensureCapacity(int bytes) {
        if (this._size + bytes < this._data.length) {
            return;
        }
        int newSize = this._data.length * this._expandBy / 100;
        this.setCapacity(Math.max(newSize, this._size + bytes));
    }

    private void setCapacity(int size) {
        if (size < this._size) {
            return;
        }
        byte[] newData = new byte[size];
        for (int ii2 = 0; ii2 < this._size; ++ii2) {
            newData[ii2] = this._data[ii2];
        }
        this._data = newData;
    }
}

