/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.util;

import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable {
    private String[] _colNames;
    private Class<?>[] _colClasses;
    private ArrayList<Object[]> _data;
    private HashMap<String, Integer> _name2Col;

    public DataTable(String[] colNames, Class<?>[] colClasses, Object[][] data) {
        if (colClasses != null && colClasses.length != colNames.length) {
            throw new IllegalArgumentException("colClasses not same size as colNames (expected: " + colNames.length + ", got: " + colClasses.length + ")");
        }
        this._colNames = new String[colNames.length];
        this._name2Col = new HashMap();
        this._colClasses = new Class[this._colNames.length];
        for (int col = 0; col < colNames.length; ++col) {
            this._colNames[col] = colNames[col];
            this._name2Col.put(colNames[col], col);
            this._colClasses[col] = colClasses != null ? colClasses[col] : null;
        }
        this._data = new ArrayList();
        if (data != null) {
            for (int row = 0; row < data.length; ++row) {
                this.internalAddRow(row, data[row]);
            }
        }
    }

    public DataTable(String[] colNames) {
        this(colNames, null, null);
    }

    public int size() {
        return this._data.size();
    }

    public int getColumnCount() {
        return this._colNames.length;
    }

    public String getColumnName(int col) {
        return this._colNames[col];
    }

    public Class<?> getColumnClass(int col) {
        return this._colClasses[col];
    }

    public Object getValue(int row, int col) {
        Object[] rowData = this._data.get(row);
        return rowData[col];
    }

    public Object setValue(int row, int col, Object val) {
        this.checkClass(row, col, val);
        Object[] rowData = this._data.get(row);
        Object oldValue = rowData[col];
        rowData[col] = val;
        return oldValue;
    }

    public void addRow() {
        this.internalAddRow(this._data.size(), new Object[this.getColumnCount()]);
    }

    public void addRow(Object[] rowData) {
        this.internalAddRow(this._data.size(), rowData);
    }

    private void checkRowSize(int row, Object[] rowData) {
        if (rowData.length != this._colNames.length) {
            throw new IllegalArgumentException("row[" + row + "] has incorrect size: " + "expected: " + this._colNames.length + ", got: " + rowData.length);
        }
    }

    private void checkClass(int row, int col, Object obj) {
        if (this._colClasses[col] != null && obj != null && !this._colClasses[col].isInstance(obj)) {
            throw new ClassCastException("cell[" + row + "," + col + "]: " + "expected " + this._colClasses[col].getName() + ", got " + obj.getClass().getName());
        }
    }

    private void internalAddRow(int row, Object[] rowData) {
        this.checkRowSize(row, rowData);
        Object[] lclData = new Object[this._colNames.length];
        for (int col = 0; col < this._colNames.length; ++col) {
            this.checkClass(row, col, rowData[col]);
            lclData[col] = rowData[col];
        }
        this._data.add(lclData);
    }
}

