/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.XmlException;
import net.sf.practicalxml.internal.TransformerFactoryHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLReader;

public class OutputUtil {
    public static String elementToString(Element elem) {
        return OutputUtil.appendElementString(new StringBuilder(256), elem).toString();
    }

    public static String treeToString(Element elem, int indent) {
        return OutputUtil.appendTreeString(new StringBuilder(1024), elem, indent, 0).toString();
    }

    public static void compact(Source src, Result target) {
        TransformerFactoryHelper fact = new TransformerFactoryHelper();
        OutputUtil.transform(fact, src, target);
    }

    public static void indented(Source src, Result target, int indent) {
        TransformerFactoryHelper fact = new TransformerFactoryHelper().setIndent(indent);
        OutputUtil.transform(fact, src, target);
    }

    public static String compactString(Document dom) {
        StringWriter out = new StringWriter();
        OutputUtil.compact(new DOMSource(dom), new StreamResult(out));
        return out.toString();
    }

    public static String compactString(XMLReader reader) {
        StringWriter out = new StringWriter();
        OutputUtil.compact(new SAXSource(reader, null), new StreamResult(out));
        return out.toString();
    }

    public static String indentedString(Document dom, int indent) {
        StringWriter out = new StringWriter();
        OutputUtil.indented(new DOMSource(dom), new StreamResult(out), indent);
        return out.toString();
    }

    public static String indentedString(XMLReader reader, int indent) {
        StringWriter out = new StringWriter();
        OutputUtil.indented(new SAXSource(reader, null), new StreamResult(out), indent);
        return out.toString();
    }

    public static void compactStream(Document dom, OutputStream stream) {
        OutputUtil.compact(new DOMSource(dom), new StreamResult(stream));
        OutputUtil.flushStream(stream);
    }

    public static void compactStream(XMLReader reader, OutputStream stream) {
        OutputUtil.compact(new SAXSource(reader, null), new StreamResult(stream));
        OutputUtil.flushStream(stream);
    }

    public static void compactStream(Document dom, OutputStream stream, String encoding) {
        TransformerFactoryHelper fact = new TransformerFactoryHelper().setPrologue(encoding);
        OutputUtil.transform(fact, new DOMSource(dom), new StreamResult(stream));
        OutputUtil.flushStream(stream);
    }

    public static void compactStream(XMLReader reader, OutputStream stream, String encoding) {
        TransformerFactoryHelper fact = new TransformerFactoryHelper().setPrologue(encoding);
        OutputUtil.transform(fact, new SAXSource(reader, null), new StreamResult(stream));
        OutputUtil.flushStream(stream);
    }

    private static StringBuilder appendElementString(StringBuilder buf, Element elem) {
        String namespaceURI = elem.getNamespaceURI();
        String localName = DomUtil.getLocalName(elem);
        return buf.append("{").append(namespaceURI != null ? namespaceURI : "").append("}").append(localName);
    }

    private static StringBuilder appendTreeString(StringBuilder buf, Element elem, int indent, int curIndent) {
        if (buf.length() > 0) {
            buf.append("\n");
        }
        for (int ii2 = 0; ii2 < curIndent; ++ii2) {
            buf.append(" ");
        }
        OutputUtil.appendElementString(buf, elem);
        for (Element child : DomUtil.getChildren(elem)) {
            OutputUtil.appendTreeString(buf, child, indent, curIndent + indent);
        }
        return buf;
    }

    private static void flushStream(OutputStream stream) {
        try {
            stream.flush();
        }
        catch (IOException e2) {
            throw new XmlException("unable to generate output", e2);
        }
    }

    private static void transform(TransformerFactoryHelper factory, Source source, Result result) {
        Transformer xform = factory.newTransformer();
        try {
            xform.transform(source, result);
        }
        catch (TransformerException e2) {
            throw new XmlException("unable to generate output", e2);
        }
    }
}

