/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.kdgcommons.lang.StringUtil;
import net.sf.practicalxml.XmlException;

public class XmlUtil {
    private static final boolean[] LEGAL_CONTROL_CHARS = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static ThreadLocal<DateFormat> _xsdDatetimeFormatter = new ThreadLocal();
    private static ThreadLocal<DecimalFormat> _xsdDecimalFormatter = new ThreadLocal();

    public static boolean isLegal(String s2) {
        for (int ii2 = 0; ii2 < s2.length(); ++ii2) {
            if (XmlUtil.isLegal(s2.charAt(ii2))) continue;
            return false;
        }
        return true;
    }

    public static String stripIllegals(String s2) {
        StringBuilder buf = null;
        for (int ii2 = 0; ii2 < s2.length(); ++ii2) {
            char c2 = s2.charAt(ii2);
            if (!XmlUtil.isLegal(c2)) {
                if (buf != null) continue;
                buf = new StringBuilder(s2.length());
                buf.append(s2.substring(0, ii2));
                continue;
            }
            if (buf == null) continue;
            buf.append(c2);
        }
        return buf != null ? buf.toString() : s2;
    }

    public static String formatXsdDatetime(Date date) {
        return XmlUtil.getXsdDatetimeFormatter().format(date);
    }

    public static Date parseXsdDatetime(String value) throws XmlException {
        try {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(0L);
            int idx = XmlUtil.parserHelper(value, cal, 1, 0);
            idx = XmlUtil.parserHelper(value, cal, 2, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 5, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 11, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 12, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 13, idx + 1);
            if (idx < value.length() && value.charAt(idx) == '.') {
                idx = XmlUtil.parserHelper(value, cal, 14, idx + 1);
            }
            XmlUtil.parseTimezone(value, cal, idx);
            return cal.getTime();
        }
        catch (Exception ex2) {
            throw new XmlException("unable to parse: " + value, ex2);
        }
    }

    public static String formatXsdDecimal(double value) {
        return XmlUtil.formatXsdDecimal((Number)value);
    }

    public static String formatXsdDecimal(Number value) {
        if (value == null) {
            return "";
        }
        return XmlUtil.getXsdDecimalFormatter().format(value);
    }

    public static String formatXsdBoolean(boolean value) {
        return value ? "true" : "false";
    }

    public static boolean parseXsdBoolean(String value) {
        try {
            value = value.trim();
            if (value.equals("true") || value.equals("1")) {
                return true;
            }
            if (value.equals("false") || value.equals("0")) {
                return false;
            }
            throw new XmlException("not an XSD boolean value: " + value);
        }
        catch (NullPointerException e2) {
            throw new XmlException("null values not allowed");
        }
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(s2.length());
        boolean wasEscaped = false;
        block7: for (int ii2 = 0; ii2 < s2.length(); ++ii2) {
            char c2 = s2.charAt(ii2);
            switch (c2) {
                case '&': {
                    buf.append("&amp;");
                    wasEscaped = true;
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    wasEscaped = true;
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    wasEscaped = true;
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    wasEscaped = true;
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    wasEscaped = true;
                    continue block7;
                }
                default: {
                    buf.append(c2);
                }
            }
        }
        return wasEscaped ? buf.toString() : s2;
    }

    public static String unescape(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(s2.length() + 20);
        boolean wasEscaped = false;
        block3: for (int ii2 = 0; ii2 < s2.length(); ++ii2) {
            char c2 = s2.charAt(ii2);
            switch (c2) {
                case '&': {
                    ii2 = XmlUtil.unescapeHelper(s2, ii2, buf);
                    wasEscaped = true;
                    continue block3;
                }
                default: {
                    buf.append(c2);
                }
            }
        }
        return wasEscaped ? buf.toString() : s2;
    }

    private static boolean isLegal(char c2) {
        if (c2 < '\ud800') {
            return c2 < ' ' ? LEGAL_CONTROL_CHARS[c2] : true;
        }
        return c2 >= '\ue000';
    }

    private static DateFormat getXsdDatetimeFormatter() {
        DateFormat format = _xsdDatetimeFormatter.get();
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            _xsdDatetimeFormatter.set(format);
        }
        return format;
    }

    private static DecimalFormat getXsdDecimalFormatter() {
        DecimalFormat format = _xsdDecimalFormatter.get();
        if (format == null) {
            format = new DecimalFormat("#0.0################;-#");
            _xsdDecimalFormatter.set(format);
        }
        return format;
    }

    private static int parserHelper(String value, Calendar result, int fieldId, int index) {
        int endIndex = index;
        switch (fieldId) {
            case 1: {
                endIndex = value.indexOf(45, index + 1);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                endIndex += 2;
                break;
            }
            case 14: {
                endIndex = value.indexOf(43, index);
                if (endIndex < 0) {
                    endIndex = value.indexOf(45, index);
                }
                if (endIndex < 0) {
                    endIndex = value.indexOf(90, index);
                }
                if (endIndex >= 0) break;
                endIndex = value.length();
            }
        }
        int fieldValue = Integer.parseInt(value.substring(index, endIndex));
        switch (fieldId) {
            case 2: {
                --fieldValue;
            }
        }
        result.set(fieldId, fieldValue);
        return endIndex;
    }

    private static void parseTimezone(String value, Calendar cal, int index) {
        String tz2 = "GMT";
        if (index < value.length()) {
            char tz0 = value.charAt(index);
            if (tz0 == '+' || tz0 == '-') {
                tz2 = "GMT" + value.substring(index);
            } else if (tz0 != 'Z' && tz0 != 'z') {
                throw new XmlException("invalid timezone designator: " + value.substring(index));
            }
        }
        cal.setTimeZone(TimeZone.getTimeZone(tz2));
    }

    private static int unescapeHelper(String s2, int curPos, StringBuilder buf) {
        try {
            char c2;
            if (s2.startsWith("&amp;", curPos)) {
                buf.append("&");
                return curPos + 4;
            }
            if (s2.startsWith("&apos;", curPos)) {
                buf.append("'");
                return curPos + 5;
            }
            if (s2.startsWith("&quot;", curPos)) {
                buf.append('\"');
                return curPos + 5;
            }
            if (s2.startsWith("&lt;", curPos)) {
                buf.append("<");
                return curPos + 3;
            }
            if (s2.startsWith("&gt;", curPos)) {
                buf.append(">");
                return curPos + 3;
            }
            if (s2.startsWith("&#", curPos) && (c2 = XmlUtil.numericEntityHelper(s2, curPos)) != '\u0000') {
                buf.append(c2);
                return s2.indexOf(59, curPos);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        buf.append('&');
        return curPos;
    }

    private static char numericEntityHelper(String s2, int curPos) {
        char c2;
        int value = 0;
        int multiplier = 10;
        if (s2.charAt(curPos += 2) == 'x') {
            multiplier = 16;
            ++curPos;
        }
        for (int ii2 = 0; ii2 < 6 && (c2 = s2.charAt(curPos + ii2)) != ';'; ++ii2) {
            int cVal = StringUtil.parseDigit(c2, multiplier);
            if (cVal < 0) {
                return '\u0000';
            }
            value = value * multiplier + cVal;
        }
        if (value > 65535) {
            return '\u0000';
        }
        return (char)value;
    }
}

