/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.practicalxml.xpath.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionResolver
implements XPathFunctionResolver,
Cloneable {
    private Map<QName, FunctionHolder> _table = new HashMap<QName, FunctionHolder>();

    public FunctionResolver addFunction(AbstractFunction<?> func) {
        FunctionHolder holder = this._table.get(func.getQName());
        if (holder == null) {
            holder = new FunctionHolder(func);
            this._table.put(func.getQName(), holder);
        } else {
            holder.put(func);
        }
        return this;
    }

    public FunctionResolver addFunction(XPathFunction func, QName name) {
        return this.addFunction(func, name, 0, Integer.MAX_VALUE);
    }

    public FunctionResolver addFunction(XPathFunction func, QName name, int argCount) {
        return this.addFunction(func, name, argCount, argCount);
    }

    public FunctionResolver addFunction(XPathFunction func, QName name, int minArgCount, int maxArgCount) {
        return this.addFunction(new StandardFunctionAdapter(func, name, minArgCount, maxArgCount));
    }

    @Override
    public XPathFunction resolveFunction(QName functionName, int arity) {
        FunctionHolder holder = this._table.get(functionName);
        return holder != null ? holder.get(arity) : null;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FunctionResolver) {
            return ((Object)this._table).equals(((FunctionResolver)obj)._table);
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this._table.keySet()).hashCode();
    }

    public String toString() {
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry<QName, FunctionHolder> fn2 : this._table.entrySet()) {
            QName name = fn2.getKey();
            FunctionHolder holder = fn2.getValue();
            StringBuilder sb2 = new StringBuilder(64);
            for (AbstractFunction<?> func : holder.getAll()) {
                sb2.append("{").append(name.getNamespaceURI()).append("}").append(name.getLocalPart()).append("(").append(func.getMinArgCount()).append(":").append(func.getMaxArgCount()).append(")");
                items.add(sb2.toString());
            }
        }
        return ((Object)items).toString();
    }

    public FunctionResolver clone() {
        try {
            FunctionResolver ret = (FunctionResolver)super.clone();
            ret._table = new HashMap<QName, FunctionHolder>(this._table);
            return ret;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException("should never be thrown unless class hierarchy is changed", e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandardFunctionAdapter
    extends AbstractFunction<Object> {
        final XPathFunction _func;

        public StandardFunctionAdapter(XPathFunction func, QName name, int minArgCount, int maxArgCount) {
            super(name, minArgCount, maxArgCount);
            this._func = func;
        }

        @Override
        public Object evaluate(List args) throws XPathFunctionException {
            return this._func.evaluate(args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionHolder {
        private AbstractFunction<?> _onlyOne;
        private TreeSet<AbstractFunction<?>> _hasMany;

        public FunctionHolder(AbstractFunction<?> initial) {
            this._onlyOne = initial;
        }

        public void put(AbstractFunction<?> func) {
            if (this._hasMany != null) {
                this._hasMany.remove(func);
                this._hasMany.add(func);
            } else if (this._onlyOne.equals(func)) {
                this._onlyOne = func;
            } else {
                this._hasMany = new TreeSet();
                this._hasMany.add(func);
                this._hasMany.add(this._onlyOne);
                this._onlyOne = null;
            }
        }

        public AbstractFunction<?> get(int arity) {
            if (this._onlyOne != null) {
                return this._onlyOne.isArityMatch(arity) ? this._onlyOne : null;
            }
            for (AbstractFunction<?> func : this._hasMany) {
                if (!func.isArityMatch(arity)) continue;
                return func;
            }
            return null;
        }

        public Set<AbstractFunction<?>> getAll() {
            if (this._onlyOne != null) {
                return new TreeSet(Arrays.asList(this._onlyOne));
            }
            return this._hasMany;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FunctionHolder) {
                FunctionHolder that = (FunctionHolder)obj;
                return this._onlyOne != null ? this._onlyOne.equals(that._onlyOne) : this._hasMany.equals(that._hasMany);
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }
}

