/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceResolver
implements NamespaceContext {
    private final String _prefix;
    private final String _nsURI;
    private final List<String> _prefixes;

    public SimpleNamespaceResolver(String prefix, String nsURI) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix may not be null");
        }
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI may not be null");
        }
        this._prefix = prefix;
        this._nsURI = nsURI;
        this._prefixes = Arrays.asList(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix may not be null");
        }
        if (this._prefix.equals(prefix)) {
            return this._nsURI;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    @Override
    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI may not be null");
        }
        if (nsURI.equals(this._nsURI)) {
            return this._prefix;
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String nsURI) {
        String prefix = this.getPrefix(nsURI);
        if (this._prefix.equals(prefix)) {
            return this._prefixes.iterator();
        }
        if (prefix == null) {
            return Collections.emptyList().iterator();
        }
        return Arrays.asList(prefix).iterator();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SimpleNamespaceResolver) {
            SimpleNamespaceResolver that = (SimpleNamespaceResolver)obj;
            return this._prefix.equals(that._prefix) && this._nsURI.equals(that._nsURI);
        }
        return false;
    }

    public int hashCode() {
        return this._prefix.hashCode() ^ this._nsURI.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this._prefix.length() + this._nsURI.length() + 10);
        if ("".equals(this._prefix)) {
            buf.append("xmlns=\"").append(this._nsURI).append("\"");
        } else {
            buf.append("xmlns:").append(this._prefix).append("=\"").append(this._nsURI).append("\"");
        }
        return buf.toString();
    }
}

