/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import net.sf.practicalxml.xpath.AbstractFunction;
import net.sf.practicalxml.xpath.FunctionResolver;
import net.sf.practicalxml.xpath.XPathWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathWrapperFactory
implements Cloneable {
    private Map<String, XPathWrapper> _simpleCache;
    private ThreadLocal<Map<String, XPathWrapper>> _threadsafeCache;
    private Map<String, String> _namespaces = new HashMap<String, String>();
    private Map<QName, Object> _variables = new HashMap<QName, Object>();
    private FunctionResolver _functions = new FunctionResolver();

    public XPathWrapperFactory() {
        this(CacheType.NONE);
    }

    public XPathWrapperFactory(CacheType cacheType) {
        switch (cacheType) {
            case SIMPLE: {
                this._simpleCache = new HashMap<String, XPathWrapper>();
                break;
            }
            case THREADSAFE: {
                this._threadsafeCache = new ThreadLocal<Map<String, XPathWrapper>>(){

                    @Override
                    protected Map<String, XPathWrapper> initialValue() {
                        return new HashMap<String, XPathWrapper>();
                    }
                };
                break;
            }
        }
    }

    public XPathWrapperFactory bindNamespace(String prefix, String nsURI) {
        this._namespaces.put(prefix, nsURI);
        return this;
    }

    public XPathWrapperFactory bindVariable(String name, Object value) {
        return this.bindVariable(new QName(name), value);
    }

    public XPathWrapperFactory bindVariable(QName name, Object value) {
        this._variables.put(name, value);
        return this;
    }

    public XPathWrapperFactory bindFunction(AbstractFunction<?> func) {
        this._functions.addFunction(func);
        return this;
    }

    public XPathWrapperFactory bindFunction(AbstractFunction<?> func, String prefix) {
        this._functions.addFunction(func);
        this.bindNamespace(prefix, func.getNamespaceUri());
        return this;
    }

    public XPathWrapperFactory bindFunction(QName name, XPathFunction func) {
        this._functions.addFunction(func, name);
        return this;
    }

    public XPathWrapperFactory bindFunction(QName name, XPathFunction func, int arity) {
        this._functions.addFunction(func, name, arity);
        return this;
    }

    public XPathWrapperFactory bindFunction(QName name, XPathFunction func, int minArity, int maxArity) {
        this._functions.addFunction(func, name, minArity, maxArity);
        return this;
    }

    public XPathWrapper newXPath(String xpath) {
        XPathWrapper wrapper = this.retrieveFromCache(xpath);
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = new XPathWrapper(xpath);
        for (Map.Entry<String, String> entry : this._namespaces.entrySet()) {
            wrapper.bindNamespace(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this._variables.entrySet()) {
            wrapper.bindVariable((QName)entry.getKey(), entry.getValue());
        }
        wrapper.setFunctionResolver(this._functions.clone());
        this.addToCache(xpath, wrapper);
        return wrapper;
    }

    private XPathWrapper retrieveFromCache(String xpath) {
        if (this._simpleCache != null) {
            return this._simpleCache.get(xpath);
        }
        if (this._threadsafeCache != null) {
            return this._threadsafeCache.get().get(xpath);
        }
        return null;
    }

    private void addToCache(String xpath, XPathWrapper wrapper) {
        if (this._simpleCache != null) {
            this._simpleCache.put(xpath, wrapper);
        } else if (this._threadsafeCache != null) {
            this._threadsafeCache.get().put(xpath, wrapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheType {
        NONE,
        SIMPLE,
        THREADSAFE;

    }
}

